function TrClusterNew=...
    PackDlt2TrClusters(TrClusters,imnames,Detectlets2Tr,tr,Detectlets,verbose)


ncl=length(TrClusters);
ndlt=length(Detectlets);
ntr=length(tr);

[XYT,tr_id]=quick_tr(tr);
%****************alignement score*******%

[Coverage,CoverageM]=AlignmentDlt2Trcluster(Detectlets,...
    TrClusters,tr,Detectlets2Tr,imnames);


%hypothesize detectlet unions
clear TrClusterNew
cnt=0;
for i=1:ncl
    
    ts=TrClusters(i).ts;
    A=squeeze(Coverage(:,i,ts));
    if length(ts)>1 && ndlt>1
        mins=min(A,[],2);
    elseif length(ts)==1 && ncl>1
        mins=A;
    elseif (length(ts)>1 && ncl==1)||(length(ts)>1 && ndlt==1)
        mins=min(A);
    end
    dlt_inds1=find(mins>0.70);
    
    B=squeeze(CoverageM(:,i,ts));
    if length(ts)>1 && ndlt>1
        maxs=max(B,[],2);
    elseif (length(ts)==1 && ncl>1)
        maxs=B;
    elseif (length(ts)>1 && ncl==1)||(length(ts)>1 && ndlt==1)
        maxs=max(B);
    end
    dlt_inds2=find(maxs>0.60);
    dlt_inds=intersect(dlt_inds1,dlt_inds2);
    if isempty(dlt_inds)
        continue;
        
        
    else
        
        
        
        
        boxes_covered=cat(2,Detectlets(dlt_inds).box);
        
        TrClusters(i).label=filterTrClusterBox...
            (find(TrClusters(i).label),{boxes_covered},tr,imnames);
        
        boxes = propagate_boxes(boxes_covered, tr(TrClusters(i).label==1),...
            []);
        
        TrClusters(i).label=filterTrClusterBox...
            (find(TrClusters(i).label),boxes,tr,imnames);
        
        boxes = propagate_boxes(boxes_covered, tr(TrClusters(i).label==1),...
            []);
        
        TrClusters(i).label=filterTrClusterBox...
            (find(TrClusters(i).label),boxes,tr,imnames);
        %         if nnz((keep==1) & (TrClusters(i).label==1))/nnz(keep==1 | TrClusters(i).label==1)<0.7
        %             continue;
        %         end
        a=zeros(1,ntr);
        a(tr_id(ismember(XYT(3,:),boxes(5,:))))=1;
        TrClusters(i).label=TrClusters(i).label.*a;
        cnt=cnt+1;
        TrClusterNew(cnt).boxes=boxes;
        TrClusterNew(cnt).label=TrClusters(i).label;
        TrClusterNew(cnt).ts=boxes(5,:);
        TrClusterNew(cnt).dlt_ids=dlt_inds;
        TrClusterNew(cnt).cl_score=size(boxes_covered,2);
        %         TrClusterNew(cnt).cl_score=size(boxes,2);
    end
    TrClusterNew(cnt).score=...
        sum(cat(2,Detectlets(TrClusterNew(cnt).dlt_ids).confidence));
    
end

return;




