function [Detectlets2Tr]=AssociateDetectlets2Tr(Detectlets,detections,tr,...
    Detections2Tr,imnames,para)
Detections2Tr=Detections2Tr>0.3;
Detections2Tr=full(Detections2Tr);
ntr=length(tr);
ndet=size(detections,2);
ndlt=length(Detectlets);
[XYT,tr_id]=quick_tr(tr,0);
XYT=round(XYT);


Detectlets2Tr = zeros(ndlt, ntr);



%trajectories on in each frame
for t=1:length(imnames)
    tr_ids{t}=tr_id(find(XYT(3,:)==t));
end

%Time overlapp of detections and trajectories
TimeOverlapDet2Tr=zeros(ndet,ntr);
for i=1:ndet
    t=detections(5,i);
    TimeOverlapDet2Tr(i,tr_ids{t})=1;
end


for i=1:ndlt
  
    det_ids=Detectlets(i).box(6,:);
    
    %time overlap of current detectlet and trajectories
    a=sum(TimeOverlapDet2Tr(det_ids,:),1);
    
    %space/time overlap of current detectlet and trajectories
    b=sum(Detections2Tr(det_ids,:),1);
    c=b./a;
    
    trids=find(c>=para.detlet2tr_th);
    Detectlets2Tr(i,trids)=c(trids);
end