function [para]=get_para(video_dir, extension,fps)                           
[imnames]          = get_file_list(video_dir,extension);
[p,q,~]            = size(imread(imnames(1).name));
para{1}=get_para_general(video_dir,p,q,fps,extension);
para{2}=get_para_flow(p,q);
para{2}.flow_dir=para{1}.flow_dir;

function para=get_para_general(video_dir,p,q,fps,extension);
%% Overall Video Stats
para.extension     = extension;  %% image extension
para.p             = p;                                     %% image height
para.q             = q;                                     %% image width
para.verbose       = 0;                                     %% show middle result                              %% # frame
para.fps=fps;
%%  Trajectory
para.flow_dir = setdir([video_dir 'flow/']);                %% Flow directory
para.fb_check=0.1;                                           %% ForBackCheck 1
para.fb_check2=0.1;                                           %% ForBackCheck 2
para.g=20;                                                  %% Block Ratio
para.sample_step=8;                                         %% Spatial sample rate                   %% Short Trajectory threshold
para.traj_file=[video_dir 'tr.mat'];
para.tr_len_thresh=[floor(para.fps/3) floor(para.fps)];
%% Affinity on Trajectory
para.aggr=para.tr_len_thresh(1);                       %% velocity support                                       %% speed variance
para.dist_thresh_x=round(q/4);                              %% spatial neighbour (x)
para.dist_thresh_y=round(p/4);                              %% spatial neighbour (y)
para.my_var_ut=0.01;
para.aggr=3;
para.my_var_euk=0.005;
%% Ncut on Trajectory
para.nv_min=5;                                              %% min # eigv
  para.spectral_gap_th=0.2;                                %% spectral threshold
para.nv_nonsteer=100;  %% max # nv
para.nv_steer=200;
para.ncut_score_thresh=0.5;
%% Detection
para.det_score_thresh=2;
para.detectlet_dir=setdir(fullfile(video_dir, 'detectlets/'));
para.detectlet_file=[para.detectlet_dir 'detectlets.mat'];
para.detlet2tr_th=0.9;
inds=strfind(video_dir,'/');
para.result_dir=setdir([video_dir 'results_' video_dir(inds(end-2)+1:inds(end-1)-1) '/']);
para.detection_dir = setdir([para.detectlet_dir 'detection/']);
para.poselet_dir = setdir([para.detection_dir, 'poselet/']);
para.tr_sharing_thresh=0.3;
para.thresh_linking_absolute=0.1;
para.thresh_linking_relative=0.3;
para.result_file = fullfile(para.result_dir, 'result.mat');
para.min_dlt_len_steer=3;
para.tgap=2*para.fps;
%% stereo
para.stereo=0;  %% in later releases there will be an option to use stereo
