%% input
video_dir=['./data/sequence01/images_left/'];
fps=7;
extension='jpg';
%%




[para]=get_para(video_dir, extension,fps);
imnames=get_file_list(video_dir,extension);
ts=cell2struct(num2cell(1:length(imnames)),'t',1);
imnames = cell2struct([struct2cell(imnames); struct2cell(ts')], ...
    [fieldnames(imnames); fieldnames(ts)], 1);




%% compute trajectories
tr           =  computeTr(imnames, para);
ntr=length(tr);


%%  detect objects
disp('detect objects...');
[detections, detection_masks] = detect_all(imnames,para{1});

%% associate tr to detections
Detections2Tr=AssociateDetections2Tr(tr,detections,detection_masks,imnames,...
    para{1});

%% compute detectlets
disp('link detections to detectlets...');
[Detectlets,Detections2Detectlets]=compute_detectlets(detections,Detections2Tr,imnames,...
    tr,para{1});




%% Associate tr 2 detectlets
disp('associate trajectlets to detectlets..');
[Detectlets2Tr]=AssociateDetectlets2Tr(Detectlets,detections,tr,...
    Detections2Tr,imnames,para{1});



%% 1. compute steered segmentations
tr_ids_select = find(sum(Detectlets2Tr(cat(1,Detectlets(:).len)>=2,:),1)>0);
[TrDltClustersSteer]=TrDltSteeringCut(tr(tr_ids_select), ...
    Detectlets,...
    Detectlets2Tr(:,tr_ids_select),imnames,para{1}.nv_steer,para{1});%,...
for i=1:length(TrDltClustersSteer)
    a=zeros(1,ntr);
    a(tr_ids_select)=TrDltClustersSteer(i).label;
    TrDltClustersSteer(i).label=a;
end

%%  2. compute nonsteered segmentations
[TrClusters]=tr_clustering(tr,imnames,para{1}.nv_nonsteer,para{1});
TrDltClustersNonsteer=PackDlt2TrClusters(TrClusters,imnames,Detectlets2Tr,tr,...
    Detectlets,0);



%% nms
disp('nms... \n');
TrDltClusters=cat(2,TrDltClustersSteer,TrDltClustersNonsteer);
[TrDltClustersF,cl_selected]=...
    nmsCoclusters(TrDltClusters,imnames,tr,0);




%% visualize results
[~,Boxes]=TrClusters2Trlabels(tr,TrDltClustersF);
h = plot_trajectory_clusters_boxes(TrDltClustersF, Boxes, ...
    imnames(1:end),[],1,1,4);
nlabels=length(TrDltClustersF);
cols = jet(nlabels);
cols = cols(randperm(nlabels),:);
[~,Boxes]=TrClusters2Trlabels(tr,TrDltClustersF);
for i=1:length(imnames)
    h = plot_trajectory_clusters_boxes(TrDltClustersF, Boxes, ...
        imnames(i),cols,0,0,10);
    save_tight(h,[para{1}.result_dir 'results_' num2str(i) '.png']);
    %saveas(h,[para{1}.result_dir 'results_' num2str(i) '.png']);
end



save([para{1}.result_dir 'results.mat'], 'tr','TrDltClustersF','Boxes');

