%
% a deterministic merge sort
%
%   changing nested >-> to ->> in last subgoal of
%     1st msort clause gives an insertion sort
% 

module sortOLL.

accumulate olli.

prog(
merge (H1 :: T1) (H2 :: T2) (H2 :: T3)
	<-  `(H1 > H2)
	<-  merge (H1 :: T1) T2 T3
).

prog(
merge (H1 :: T1) (H2 :: T2) (H1 :: T3)
	<-  `(H1 =< H2)
	<-  merge T1 (H2 :: T2) T3
).

prog( merge L nil L ).

prog( merge nil L L ).


prog( 
mergeSort (H :: T) L
        <<- ( srt (H :: nil) ->>  mergeSort T L)
).

prog( mergeSort nil L <<-  msort L ).

prog( 
msort L
	<<-  srt L1
	<<-  srt L2 
	<-   merge L1 L2 L12
	<<- (srt L12 >-> msort L)
).

prog( msort L <<- srt L ).

prog( msort nil ).


%
% sample query
%
% olli (mergeSort [5,4,3,6,7,8,5,9,1] L).
%













