module olli.


%
% residual fragment
%
type eq frm -> frm -> frm.
type bang frm -> frm.
type mobi frm -> frm.
type one frm.
type *r frm -> frm -> frm. infixr *r 20.
type *l  frm -> frm -> frm. infixr *l 20.
type some (A -> frm) -> frm.
type zero frm.
type plus frm -> frm -> frm. infixr plus 20.


kind pairT type -> type -> type.
type pair A -> B -> pairT A B.

kind bit type.
type tt bit.
type ff bit.

%
% ordered context elements
%
kind eltO  type.
type clsO  pairT int frm -> eltO.
type boxO  eltO.
type >>  int -> eltO. postfix >> 30.
type <<  int -> eltO. 

%
% linear context elements
%
kind eltL  type.
type clsL  (frm -> frm) -> eltL.
type boxL  eltL.
type <>  eltL.


type resid frm -> frm -> (frm -> frm) -> o.

type aseq  list (frm -> frm) -> list eltL -> list eltL -> bit ->
           list eltO -> list eltO -> int -> list bit -> frm -> o.

type sseq  list (frm -> frm) -> list eltL -> list eltL -> bit ->
           list eltO -> list eltO -> list eltO -> list eltO -> 
           int -> list bit -> list bit -> 
           frm -> frm -> o.

type mrg list eltO -> list bit -> 
          list eltO -> list bit ->
          list eltO -> list bit -> o.




type or  bit -> bit -> bit -> o.
or ff ff ff :- !.
or _ _ tt.

type and  bit -> bit -> bit -> o.
and tt tt tt :- !.
and _ _ ff.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% List manipulation
%
type rev  list A -> list A -> o.
type rv  list A -> list A -> list A -> o.
rev L L' :- rv nil L L'.
rv K nil K.
rv K (H::T) L :- rv (H::K) T L.


type append  list A -> list A -> list A -> o.
append nil K K.
append (X::L) K (X::M) :-  append L K M.


%
% takes off last element of a list
%
type strip  list A -> list A -> A -> o.
strip (H::nil) nil H :- !.
strip (H1::H2::T) (H1::T') H':- !, strip (H2::T) T' H'.
strip nil _ _ :- !, print "\aError... strip called with nil.\n", fail.  


%
% choose formula from unrestricted context to focus on.
%
type chooseG  list (frm -> frm) -> (frm -> frm) -> o.
chooseG (H::Rt) H. 
chooseG (_::T) H :- chooseG T H.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Bit List manipulation

%
% concatenation for top flag lists
%
type fplus list bit -> list bit -> list bit -> o.
type fp list bit -> bit -> list bit -> list bit -> o.

fp T _ nil T :- !.
fp T1 tt (tt::T2) T :- !, append T1 T2 T.
fp T1 tt (ff::T2) T :- !, append T1 (ff::T2) T.
fp T1 ff (H2::T2) T :- !, append T1 (H2::T2) T.

fplus nil T T :- !.
fplus (H::T1) T2 T :- strip (H::T1) T1' B, fp (H::T1) B T2 T.


type clipLb list bit -> list bit -> o.
clipLb nil nil.
clipLb (tt::T) T' :- clipLb T T'.
clipLb (ff::T) T.

type clipRb list bit -> list bit -> o.
clipRb T T' :- rev T T1, clipLb T1 T1', rev T1' T'.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Linear Context manipulation


%
% choose formula from linear context to focus on
%
type chooseL  list eltL -> list eltL -> (frm -> frm) -> list eltL -> o.
type chL  list eltL -> list eltL -> list eltL -> (frm -> frm) -> list eltL -> o.
chooseL L Ll B Lr :- chL nil L Ll B Lr.
chL Lt (clsL F :: Rt) Lt F Rt. 
chL Lt' (H::T) Lt F Rt :- 
    append Lt' [H] Lt'', chL Lt'' T Lt F Rt.  


%
% merge linear contexts for with_R rule
%
type mrgL (list eltL) -> bit -> list eltL -> bit -> 
          list eltL -> bit -> o.
mrgL nil tt nil tt nil tt :- !.
mrgL nil _ nil _ nil ff :- !.
mrgL (clsL A :: D1) V1 (clsL A :: D2) V2 (clsL A::D) V :- !,
    mrgL D1 V1 D2 V2 D V. 
mrgL (clsL _ :: D1) tt (boxL :: D2) V2 (boxL::D) V :- !,
    mrgL D1 tt D2 V2 D V.
mrgL (boxL :: D1) V1 (clsL _ :: D2) tt (boxL::D) V :- !,
    mrgL D1 V1 D2 tt D V.
mrgL (boxL :: D1) V1 (boxL :: D2) V2 (boxL::D) V :- !,
    mrgL D1 V1 D2 V2 D V.
mrgL (<>::D1) V1 (<>::D2) V2 (<>::D) V :- !,
    mrgL D1 V1 D2 V2 D V.


type addLPt  bit -> list eltL -> list eltL -> o.
addLPt tt D (<>::D).
addLPt ff D D.

type rmLPt  bit -> list eltL -> list eltL -> o.
rmLPt tt (_::D) D.
rmLPt ff D D.


type checkD list eltL -> o.
checkD nil.
checkD (<> :: _).
checkD (boxL :: D) :- checkD D.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Ordered Context manipulation
%
type splitL  list eltO -> list eltO -> list eltO -> o.
splitL nil nil nil :- !.
splitL (boxO :: Rest) nil (boxO :: Rest) :- !.
splitL (H:: Rest) (H:: Lt) Rt :- !, splitL Rest Lt Rt.

type splitR  list eltO -> list eltO -> list eltO -> o.
splitR L Lt Rt :- rev L L', splitL L' Lt' Rt', 
                  rev Lt' Rt, rev Rt' Lt.

%
% choose formula from ordered context to focus on.
%
type chooseO  list eltO -> list eltO -> frm -> list eltO -> o.
type chO  list eltO -> list eltO -> list eltO -> frm -> list eltO -> o.
chooseO L Ll B Lr :- chO nil L Ll B Lr.
chO Lt (clsO (pair _ F) :: Rt) Lt F Rt. 
chO Lt' (H::T) Lt F Rt :- 
    append Lt' [H] Lt'', chO Lt'' T Lt F Rt.  


%
% merging for with_R rule
%
type mrg list eltO -> list bit -> 
          list eltO -> list bit ->
          list eltO -> list bit -> o.

mrg nil [tt] nil [tt] nil [tt] :- !.
mrg nil _ nil _ nil nil :- !.

mrg (clsO _::O1) (tt::T1) (boxO::O2) (ff::T2) (boxO::O) (ff::T) 
    :- !, mrg O1 (tt::T1) O2 T2 O T.
mrg (clsO _::O1) (tt::T1) (boxO::O2) (tt::ff::T2) (boxO::O) (tt::ff::T) 
    :- !, mrg O1 (tt::T1) O2 T2 O T.

mrg (boxO::O1) (ff::T1) (clsO F::O2) (tt::T2) (boxO::O) (ff::T) 
    :- !, mrg O1 T1 O2 (tt::T2) O T.
mrg (boxO::O1) (tt::ff::T1) (clsO F::O2) (tt::T2) (boxO::O) (tt::ff::T) 
    :- !, mrg O1 T1 O2 (tt::T2) O T.

mrg (boxO::O1) (ff::T1) (boxO::O2) (ff::T2) (boxO::O) (ff::T) 
    :- !, mrg O1 T1 O2 T2 O T.
mrg (boxO::O1) (tt::ff::T1) (boxO::O2) (ff::T2) (boxO::O) (ff::T) 
    :- !, mrg O1 T1 O2 T2 O T.
mrg (boxO::O1) (ff::T1) (boxO::O2) (tt::ff::T2) (boxO::O) (ff::T) 
    :- !, mrg O1 T1 O2 T2 O T.
mrg (boxO::O1) (tt::ff::T1) (boxO::O2) (tt::ff::T2) (boxO::O) (tt::ff::T)  
    :- !, mrg O1 T1 O2 T2 O T.

mrg (H::O1) T1 (H::O2) T2 (H::O) T :- !, mrg O1 T1 O2 T2 O T.


%
% helper for rules  ->>_R  and  >->_R
%
%   calculates output top flag list for these rules.
%   allows me to have one rule and reuse earlier computations
%
%   these should only be called with first arg box or cls
%
type helpR eltO -> list bit -> list bit -> o.
helpR boxO T T' :- clipRb T T'.
helpR (clsO _) T T.

type helpL eltO -> list bit -> list bit -> o.
helpL boxO T T' :- clipLb T T'.
helpL (clsO _) T T.


%
% check that ordered context is ok at leaf
%
type checkO list eltO -> o.
type chkO eltO -> eltO -> o.

checkO nil.
checkO [clsO _] :- !, fail.
checkO [_] :- !.
checkO (H1::H2::T) :- !, strip (H2::T) _ B, chkO H1 B.

chkO (N >>) (clsO (pair N' _)) :- !, N >= N'.
chkO (clsO (pair N' _)) (<< N) :- !, N >= N'.
chkO (_ >>) (<< _) :- !.
chkO (<< _) (<< _) :- !.
chkO (_ >>) (_ >>) :- !.
chkO _ _ :- !, fail.


%
% checks left side of flag list and adds pointer to
%   right side of context if flaglist begins with tt
%
type addPtR  list bit -> int -> list eltO -> list eltO -> bit -> o.
addPtR (tt :: _) N O O' tt :- !, append O [<< N] O'.
addPtR (ff :: _) _ O O ff :- !.

type rmPtR  bit -> list A -> list A -> o.
rmPtR ff O O.
rmPtR tt O O' :- strip O O' _.


type addPtL  list bit -> int -> list eltO -> list eltO -> bit -> o.
type aL  bit -> int -> list eltO -> list eltO -> bit -> o.
addPtL nil _ O O ff.
addPtL (H::T) N O O' B :- strip (H::T) _ A, aL A N O O' B.
aL tt N O ((N >>)::O) tt.
aL ff _ O O ff.

type rmPtL  bit -> list eltO -> list eltO -> o.
rmPtL tt (_::O) O.
rmPtL ff O O.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% residuation-- compile just residuates a list of forms.
%
type resid frm -> frm -> (frm -> frm) -> o.
resid K (A imp B) G :- !,  resid ((bang A) *r K) B G.
resid K (B <- A) G :- !,  resid ((bang A) *r K) B G.
resid K (A -o B) G :- !,  resid ((mobi A) *r K) B G.
resid K (B o- A) G :- !,  resid ((mobi A) *r K) B G.
resid K (A >-> B) G :- !,  resid (A *l K) B G.
resid K (B <-< A) G :- !,  resid (A *l K) B G.
resid K (A ->> B) G :- !,  resid (A *r K) B G.
resid K (B <<- A) G :- !,  resid (A *r K) B G.
resid K (all A) (p \ some (G p)) :- !,  pi x \ resid K (A x) (p \ G p x).
resid K top (p \ zero).
resid K (A with B) (p \ (G1 p) plus (G2 p)) :- !, resid K A G1, resid K B G2.
resid K ( P) (p \ (eq P p) *r K).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                                       N
% inference rules--  G ; Di\Do ; Oi\Oo ---> A
%                                      V T
%
%    V is linear top flag,  T is ordered top flag list
%
%
type aseq  list (frm -> frm) -> list eltL -> list eltL -> bit ->
           list eltO -> list eltO -> int -> list bit -> frm -> o.

type sseq  list (frm -> frm) -> list eltL -> list eltL -> bit ->
           list eltO -> list eltO -> list eltO -> list eltO -> 
           int -> list bit -> list bit -> 
           frm -> frm -> o.


aseq G Di Do V Oi Oo N T (B <- A) :- !,   
    aseq G Di Do V Oi Oo N T (A imp B).
aseq G Di Do V Oi Oo N T (B o- A) :- !,   
    aseq G Di Do V Oi Oo N T (A -o B).
aseq G Di Do V Oi Oo N T (B <<- A) :- !,   
    aseq G Di Do V Oi Oo N T (A ->> B).
aseq G Di Do V Oi Oo N T (B <-< A) :- !,   
    aseq G Di Do V Oi Oo N T (A >-> B).


aseq G D D ff O O _ nil (` P) :- !,
    checkO O, checkD D, P.


aseq G D D ff O O _ nil (eq P P') :- !,
%print "eq  O= ",printterm std_out O,
%print "  D= ",printterm std_out D,
%print" P= ",printterm std_out P,
%print" P'= ",printterm std_out P',
%input std_in 1 _,
%print "\n",
    P = P', checkO O, checkD D.


aseq G D D ff O O _ nil one :- !,
    checkO O, checkD D.


aseq G Di Do V Oi Oo N T (A imp B) :-   !,  
    resid one A A', aseq (A'::G) Di Do V Oi Oo N T B.

aseq G D D ff O O N nil (bang A) :- !,
    checkO O, checkD D,
    aseq G nil nil _ nil nil N _ A.


aseq G Di Do V Oi Oo N T (A -o B) :- !,
    resid one A A', 
    aseq G (clsL A'::Di) (_::Do) V Oi Oo N T B.

aseq G Di Do V O O N nil (mobi A) :- !,  
    checkO O,
    aseq G Di Do V nil nil N _ A.


aseq G Di Do V Oi Oo N T (A >-> B) :- !,   
    append Oi [clsO (pair N A)] Oi', 
    aseq G Di Do V Oi' Oo' N T' B, 
    strip Oo' Oo A', 
    helpR A' T' T.

aseq G Di Do V Oi Oo N T (A ->> B) :- !,   
    aseq G Di Do V (clsO (pair N A)::Oi) (A'::Oo) N T' B,
    helpL A' T' T.


aseq G Di Do V Oi Oo N T (A *r B) :- !,   
    N' is (N + 1),
    append Oi [<< N] Oi',
    aseq G (<>::Di) (_::D) V1 Oi' O N' Tl A,
    strip O O' _,
    splitR O' Ol O'',
    addPtL Tl N O'' O''' Added,
    addLPt V1 D D',
    aseq G D' Do' V2 O''' Or' N' Tr B,
    rmLPt V1 Do' Do, 
    rmPtL Added Or' Or, 
    append Ol Or Oo,
    fplus Tl Tr T,
    or V1 V2 V.

aseq G Di Do V Oi Oo N T (A *l B) :- !,   
    N' is (N + 1),
    aseq G (<>::Di) (_::D) V1 ((N >>)::Oi) (_::O) N' Tr A,
    splitL O O' Or,
    addPtR Tr N O' O'' Added,
    addLPt V1 D D',
    aseq G D' Do' V2 O'' Ol' N' Tl B,
    rmLPt V1 Do' Do, 
    rmPtR Added Ol' Ol, 
    append Ol Or Oo,
    fplus Tl Tr T,
    or V1 V2 V.


aseq G D D tt O O _ [tt] top :- !.

aseq G Di Do V Oi Oo N T (A with B) :- !,
    aseq G Di D1 V1 Oi O1 N T1 A,
    aseq G Di D2 V2 Oi O2 N T2 B,
    mrg O1 T1 O2 T2 Oo T,
    mrgL D1 V1 D2 V2 Do V.


aseq G Di Do V Oi Oo N T (A plus B) :- !,
    aseq G Di Do V Oi Oo N T A.

aseq G Di Do V Oi Oo N T (A plus B) :- !,
    aseq G Di Do V Oi Oo N T B.


aseq G Di Do V Oi Oo N T (all A) :- !,
    pi x \ aseq G Di Do V Oi Oo N T (A x).

aseq G Di Do V Oi Oo N T (some A) :- !,
    aseq G Di Do V Oi Oo N T (A X).


aseq G Di Do V Oi Oo N T ( P) :- 
    chooseO Oi Oli B Ori,
    sseq G Di Do V Oli Olo Ori Oro N T1 T2 B P,
    append Olo (boxO :: Oro) Oo,
    append T1 (ff :: T2) T.

aseq G Di Do V Oi Oo N T ( P) :- 
    chooseL Di Dil B  Dir,
    append Dil (boxL::Dir) Di',
    aseq G Di' Do V Oi Oo N T (B P).

aseq G Di Do V Oi Oo N T ( P) :- 
    chooseG G B,
    aseq G Di Do V Oi Oo N T (B P).

aseq G Di Do V Oi Oo N T ( P) :- 
    (prog B), resid one B B',
    aseq G Di Do V Oi Oo N T (B' P).


sseq G Di Do V Oli Olo Ori Oro N Tl Tr (B <- A) P :- !,
    sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A imp B) P.
sseq G Di Do V Oli Olo Ori Oro N Tl Tr (B o- A) P :- !,
    sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A -o B) P.
sseq G Di Do V Oli Olo Ori Oro N Tl Tr (B <<- A) P :- !,
    sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A ->> B) P.
sseq G Di Do V Oli Olo Ori Oro N Tl Tr (B <-< A) P :- !,
    sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A >-> B) P.


sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A with B) P :- !,
    sseq G Di Do ff Oli Olo Ori Oro N Tl Tr A P.

sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A with B) P :- !,
    sseq G Di Do ff Oli Olo Ori Oro N Tl Tr B P.


sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A imp B) P :- !,
    sseq G Di Do ff Oli Olo Ori Oro N Tl Tr B P,
    aseq G [] _ _ [] _ N _ A.


sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A -o B) P :- !,
    sseq G (<>::Di) (_::D) V1 Oli Olo Ori Oro N Tl Tr B P,
    aseq G D Do V2 [] _ N _ A,
    or V1 V2 V.


sseq G Di Do V Oli Olo Ori Oro N Tl Tr' (A >-> B) P :- !,
    sseq G (<>::Di) (_::D) V1 
         Oli Olo ((N >>)::Ori) ((N >>)::Or) N Tl Tr B P,
    N' is (N + 1),
    splitL Or Oa Oro',
    addPtR Tr N Oa Oai Added,
    addLPt V1 D D',
    aseq G D' Do' V2 Oai Oao' N' T A,
    rmLPt V1 Do' Do, 
    rmPtR Added Oao' Oao, 
    append Oao Oro' Oro,
    fplus T Tr Tr',
    or V1 V2 V.

sseq G Di Do V Oli Olo Ori Oro N Tl' Tr (A ->> B) P :- !,
    append Oli [<< N] Oli',
    sseq G (<>::Di) (_::D) V1 
         Oli' Ol' Ori Oro N Tl Tr B P,
    strip Ol' Ol _,
    N' is (N + 1),
    splitR Ol Olo' Oa,
    addPtL Tl N Oa Oai Added,
    addLPt V1 D D',
    aseq G D' Do' V2 Oai Oao' N' T A,
    rmLPt V1 Do' Do, 
    rmPtL Added Oao' Oao, 
    append Olo' Oao Olo,
    fplus Tl T Tl',
    or V1 V2 V.


sseq G Di Do V Oli Olo Ori Oro N Tl Tr (all A) P :- !,
  sseq G Di Do V Oli Olo Ori Oro N Tl Tr (A X) P.


sseq G D D ff Ol Ol Or Or N nil nil ( P) P :-
    checkD D,
    checkO Ol,
    checkO Or.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


olli A :-  aseq [] [] _ _ [] _ 1 _ A.















