%
% Olli program to translate between named vars and 
%   deBruijn notation
%
module dbOLL.

accumulate olli.

prog(
tr (app E1 E2) (app' E1' E2')
  <<- (tr E1 E1') with (tr E2 E2')
).

prog(
tr (lam E) (lam' E')
  <<- all x \ var x ->> tr (E x) E'
).

prog(
tr E v
  <<- var E
  <<- top
).

prog(
tr E (shift E')
  <<- var _
  <<- tr E E'
).


%
% sample query: 
%
% olli (tr (lam x \ lam y \ app x y) E).
%
