package KTEditor;

import java.awt.*;
import javax.swing.text.*;

/**
 *
 * xx more later
 * <p>
 * 
 * @author  Scott Hudson
 */
public class TagDescriptor extends SegmentDescriptor {
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constants */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** Default color for denoting tags */
    public static final Color DEFAULT_TAG_COLOR = new Color(0.0f,0.0f,1.0f,0.5f); 
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* Drawing */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Default drawing for a rectangle with a highlight color/pattern denoting the tag.  
     * This is to be used under the text drawing.  The drawing should be limited to the 
     * given rectangle and is intending to cover the given positions within the document 
     * being edited by the given text pane.<p>
     *
     * Currently we do a simple colored area fill using the color down to the baseline only.
     */
    public void defaultDrawHighlightRect(
        Graphics g, 
        Rectangle drawRect, 
        int baselineOff,
        JTextComponent inComponent, 
        int startPos, int endPos, 
        View forView, 
        Shape viewBounds,
        int ends) 
    {
        // adjust the draw rectangle to end at baseline instead of descenders
        drawRect = baselineRect(drawRect, baselineOff+basePad);
        
        // set the color and fill the rectangle
        g.setColor(getSegmentColor());
        g.fillRect(drawRect.x,drawRect.y, drawRect.width,drawRect.height);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** font we use for drawing labels */
    protected Font labelFont = new Font("SansSerif", Font.BOLD, 9);
    /** font metrics for labelFont */
    protected FontMetrics labelMetrics = Toolkit.getDefaultToolkit().getFontMetrics(labelFont); 
    /** spacing above the label */
    protected int labelPad = 0;
    /** spacing below the baseline */
    protected int basePad = 5;
   
    /**
     * Default drawing for text at the start of a tag.
     *
     * Here we draw the text in a small font at the top of the normal highlight
     * area.
     */
    public void defaultDrawStartText(Graphics g, String text, Rectangle drawRect, int baselineOff) 
    { 
        // adjust the draw rectangle to end at baseline + pad instead of descenders
        drawRect = baselineRect(drawRect, baselineOff+basePad);
        
        // if the label text ascent is going to be more than 40% of the hieght don't do it
        if (((double)labelMetrics.getAscent()) >= (0.40*drawRect.getHeight())) return;
        
        // set up to draw text for the label clipped rect we've been given
        g.setFont(labelFont);
        Rectangle oldClip = g.getClipBounds();
        g.setClip((int)drawRect.getX(), (int)drawRect.getY(), 
                  (int)drawRect.getWidth(), (int)drawRect.getHeight());
        
        // draw text in black 
        g.setColor(Color.black);
        g.drawString(text, (int)drawRect.getX()+1,
                           (int)drawRect.getY()+labelMetrics.getAscent()+labelPad);

        // restore the clip
        g.setClip(oldClip);
    }
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** 
     * Construct a descriptor for a tag using full information.
     */
    public TagDescriptor(String nm, Color clr, Object conflGrp) 
      {super(nm,clr,conflGrp);}
  
    /** 
     * Construct a descriptor for a tag using a unique conflict group (i.e., so
     * this does not conflict with anything).
     */
    public TagDescriptor(String nm, Color clr) {this(nm,clr, new Unique());}
        
    /** 
     * Construct a descriptor for a tag using ta unique conflict group (i.e., so
     * this does not conflict with anything) and a default color.
     */
    public TagDescriptor(String nm) {this(nm,DEFAULT_TAG_COLOR, new Unique());}
    
    /** 
     * Construct a descriptor for tag from all defaults.  To be useful, this
     * tag needs to at least be given a name.
     */
    public TagDescriptor() {this("$$Default$$", DEFAULT_TAG_COLOR, new Unique());}

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
