package KTEditor;

import java.io.Serializable;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.undo.*;

/**
 * Object describing a tag that a kinetic typography effect parameter.
 * Each parameter has a name, a type, and a default value.
 * xx more later
 * <p>
 * 
 * @author  Scott Hudson
 */
public class ParameterDescriptor implements Serializable {

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* instance variables */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Name of this parameter.  This should be something suitable 
     * for display to the user 
     */
    protected String name = "$$UNNAMED_PARAMETER$$";

    /** Return the name of the parameter. */
    public String getName() {return name;}

    /** Set the name of the parameter. */
    public void setName(String nm) {name = nm;}

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /**
     * Type of this parameter.  
     */
    protected ParameterTypeDescriptor type = ParameterTypeDescriptor.ZERO_TO_ONE;

    /** Return the descriptor for the type of this parameter. */
    public ParameterTypeDescriptor getType() {return type;}

    /** Set the type of this parameter. If null is given a default type is 
     * chosen (currently ParameterTypeDescriptor.ZERO_TO_ONE).
     */
    public void setType(ParameterTypeDescriptor tp) {
      if (tp == null) tp = ParameterTypeDescriptor.ZERO_TO_ONE;
      type = tp;
    }

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** Default value for this parameter. */
    protected Object defaultValue = new Double(0.0);

    /** Get the default value for this parameter */
    public Object defaultValue() {return defaultValue;}

    /** Set the default value for this parameter */
    public void setDefaultValue(Object val) {defaultValue = val;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Construct a descriptor for a kinetic effect parameter. 
     */
    public ParameterDescriptor(
      String nm, 
      ParameterTypeDescriptor tp, 
      Object defaultVal) 
      {
        setName(nm);
        setType(tp);
        setDefaultValue(defaultVal);
      }

    /** 
     * Construct a default descriptor for a kinetic typography effect parameter.
     * This parameter will be given a default type and initial value (currently
     * a ZERO_TO_ONE type with default of 0.0).
     */
    public ParameterDescriptor(String nm) {setName(nm);}

    /** 
     * Construct a default descriptor for a kinetic typography effect parameter.
     * This parameter will be given a default type and initial value (currently
     * a ZERO_TO_ONE type with default of 0.0).  To be practically useful, this
     * parameter should be given a name.
     */
    public ParameterDescriptor() {}

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
