package KTEditor;

import javax.swing.text.*;

//xx clean up
import java.io.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.*;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

/**
 * This subclass of StyledEditorKit replaces the LabelView in 
 * the kits view factory with an ExtraLeadingLabelView. 
 */
public class ExtraLeadingStyledEditorKit extends StyledEditorKit {

  /** Amount of extra leading that this kit adds */
  protected float extraLeading = 10.0f;

  /** Get the amount of extra leading that this kit adds */
  public float getExtraLeading() {return extraLeading;}

  /** Set the amount of extra leading that this kit adds */
  public void setExtraLeading(float extraLead) {extraLeading = extraLead;}

  /** Construct a kit set up for adding a given amount of extra leading */
  public ExtraLeadingStyledEditorKit(float extraLead)
  {
    super();
    setExtraLeading(extraLead);
  }

   /**
     * Fetches a factory that is suitable for producing 
     * views of any models that are produced by this
     * kit.  This is implemented to return View implementations
     * for the following kinds of elements:
     * <ul>
     * <li>AbstractDocument.ContentElementName
     * <li>AbstractDocument.ParagraphElementName
     * <li>AbstractDocument.SectionElementName
     * <li>StyleConstants.ComponentElementName
     * <li>StyleConstants.IconElementName
     * </ul>
     * <p>
     * For this subclass we override the default factory to replace 
     * the content element view (which is LabelView in the superclass)
     * with a modified one (ExtraLeadingLabelView) that adds extra
     * leading below the text.  
     *
     * @return the factory
     */
    public ViewFactory getViewFactory() {
	return modifiedFactory;
    }

    protected final ViewFactory modifiedFactory = 
                              new ExtraLeadingStyledViewFactory();

    class ExtraLeadingStyledViewFactory implements ViewFactory {

        public View create(Element elem) {
	    String kind = elem.getName();
	    if (kind != null) {
		if (kind.equals(AbstractDocument.ContentElementName)) {
                    return new ExtraLeadingLabelView(elem, getExtraLeading());
		} else if (kind.equals(AbstractDocument.ParagraphElementName)) {
		    return new ParagraphView(elem);
		} else if (kind.equals(AbstractDocument.SectionElementName)) {
		    return new BoxView(elem, View.Y_AXIS);
		} else if (kind.equals(StyleConstants.ComponentElementName)) {
		    return new ComponentView(elem);
		} else if (kind.equals(StyleConstants.IconElementName)) {
		    return new IconView(elem);
		}
	    }
	
	    // default to text display
            return new ExtraLeadingLabelView(elem,getExtraLeading());
	}
    }
}
