package KTEditor;

import java.awt.Color;
//import java.awt.*;
//import java.awt.event.*;

//import javax.swing.*;
//import javax.swing.text.*;
//import javax.swing.event.*;
//import javax.swing.undo.*;

/**
 * Object describing a kinetic typography effect.  This object provides a 
 * list of the tags that the effect knows about and a description of each of
 * the parameters to the effect as a whole.
 * xx more later
 * <p>
 * 
 * @author  Scott Hudson
 */
public class EffectDescriptor extends SegmentDescriptor {

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* instance variables */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * The set of descriptors for tags that this effect knows about.  
     */
    protected TagDescriptor[] tags = new TagDescriptor[0];

    /** 
     * Get an array containing descriptors for the tags that this effect 
     * knows about.  
     */
    public TagDescriptor[] getTags() {return tags;}

    /** Get the number of tags this effect knows about */
    public int getNumTags() {return tags.length;}

    /** Get a particular tag descriptor from the tag descriptor list. */
    public TagDescriptor getTag(int index) {
      return tags[index];
      }

    /** 
     * Establish the set of desciptors for tags this effect knows about.
     */
    public void setTags(TagDescriptor[] tgs) {
        if (tgs == null) tgs = new TagDescriptor[0];
        tags = tgs;
      }

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** 
     * All effects share the same conflict group (hence are mutually exclusive).  This String 
     * serves as that conflict group.
     */
    protected static final String effectConflictGroup = "Effect";
    
    /**
     * All effects by default share the conflict group returned here (hence are mutually exclusive).
     */
    public static Object getEffectConflictGroup() {return effectConflictGroup;}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * The set of descriptors for parameters that that can be set for this 
     * effect.  
     */
    protected ParameterDescriptor[] parameters = new ParameterDescriptor[0];

    /** 
     * Get an array containing descriptors for the parameters that can be 
     * set for this effect.  
     */
    public ParameterDescriptor[] getParameters() {return parameters;}

    /** Get the number of parameters for this effect knows about */
    public int getNumParameters() {return parameters.length;}

    /** Get a particular parameter descriptor from the set of desciptors. */
    public ParameterDescriptor getParameter(int index) {
      return parameters[index];
    }

    /** 
     * Establish the set of parameter desciptors for this effect. 
     */
    public void setParameters(ParameterDescriptor[] parms) {
        if (parms == null) parms = new ParameterDescriptor[0];
        parameters = parms;
      }

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */

    /** 
     * Construct a descriptor for a kinetic typography effect. 
     */
    public EffectDescriptor(
      String                nm,
      Color                 clr,
      TagDescriptor[]       tagList,
      ParameterDescriptor[] paramList)
      {
        super(nm,clr, getEffectConflictGroup());
        setTags(tagList); 
        setParameters(paramList);
      }

    /** 
     * Construct a descriptor for a kinetic typography effect.  This descriptor
     * will no tags or parameters.
     */
    public EffectDescriptor(String nm, Color clr) {this(nm,clr,null,null);}    
    
    /** 
     * Construct a descriptor for a kinetic typography effect.  This descriptor
     * will no tags or parameters.
     */
    public EffectDescriptor(String nm) {super(nm); setConflictGroup(getEffectConflictGroup());}

    /** 
     * Construct a default descriptor for a kinetic typography effect.  
     * To be practically useful this descriptor will need to at least be given
     * a name.
     */
    public EffectDescriptor() {setConflictGroup(getEffectConflictGroup());}

    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
