package KTEditor;

import kinetic.*; 
import kinetic.util.*;

import java.util.Hashtable;
import java.util.ArrayList;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.awt.geom.AffineTransform;


import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.undo.*;

/**
 * Object encapsulating the Kinetic Typography Engine and all predefined effects.
 * xx more later
 * <p>
 * 
 * @author  Scott Hudson
 */
public class KTEngineInterface {
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* instance variables */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    protected static TagDescriptor[] tagsList = null;

    /** Return the descriptors for all the tags used in any effect. */
    public static TagDescriptor[] getTagsList() 
    {
        // make sure the tags list and hash table has been built 
        if (tagsList == null) 
        {
            tagsList = buildTagsList();
            // put them all in the hash table 
            for (int i = 0; i < tagsList.length; i++)
                tagsTable.put(tagsList[i].getName(), tagsList[i]);
        }
        return tagsList;
    }
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    protected static Hashtable tagsTable = new Hashtable();
    
    /** 
     * Find the descriptor for the named tag (or return null if the named tag
     * is not in use.
     */
    public static TagDescriptor findTag(String name)
    {
        // make sure table exists then look it up
        getTagsList();
        return (TagDescriptor)tagsTable.get(name);
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    protected static EffectDescriptor defaultEffect = null;
    
    public static EffectDescriptor getDefaultEffect() {return defaultEffect;}
    public static void setDefaultEffect(EffectDescriptor eff) {defaultEffect = eff;}
    
    protected static EffectDescriptor[] effectsList = null;

    /** Return the descriptors for all the effects currently supported. */
    public static EffectDescriptor[] getEffectsList() 
    {
        // make sure the tags and effects lists have been built 
        if (effectsList == null) effectsList = buildEffectsList();
        // if buildEffectsList() didn't set it, make the first effect in the
        // list be the default
        if (defaultEffect == null && effectsList != null) 
            setDefaultEffect(effectsList[0]);
            
        return effectsList;
    }
    
    static protected ArrayList tagNameList = new ArrayList();
    static protected Sequence MainSeq; //the main animation sequence.
    static protected double editTime;
    static protected Graphics2D g2;
    static protected Rectangle bounds;
    static protected Rectangle initBounds = null;
    static protected double aspectRatio;
    
    static protected BufferedImage imageBuffer;
    static protected Graphics2D bufferGraphics;
    
    static protected void setupImageBuffer(Component c)
    {
        int w = 1;
        int h = 1;
        if (c != null) 
        {
            w = c.getWidth();
            h = c.getHeight();
        }
        if (imageBuffer == null || imageBuffer.getWidth() != w || imageBuffer.getHeight() != h)
        {
            imageBuffer = new BufferedImage(w,h,BufferedImage.TYPE_INT_RGB);
        }
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* methods */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
         
    /**
     * Begin creating a new presentation.  
     */
    public static void beginPresentation(Component canvas)
    {
        bounds = canvas.getBounds();
        if(initBounds == null){
            initBounds = new Rectangle(bounds);
            aspectRatio = initBounds.width/initBounds.height;
        }
        double scale = 1.0;
        double xPos = 0;
        double yPos = 0;
        
        Rectangle newBounds = canvas.getBounds();
        double newAspectRatio = newBounds.width/newBounds.height;
        if(newAspectRatio > aspectRatio){ //the screen is wider than before
            scale = (double)newBounds.height/(double)initBounds.height;
            xPos = (newBounds.width - initBounds.width*scale)/2.0;
        }
        else{ //screen is taller than before
            scale = (double)newBounds.width/(double)initBounds.width;
            yPos = (newBounds.height - initBounds.height*scale)/2.0;
        }
        g2 = (Graphics2D)canvas.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS ,RenderingHints.VALUE_FRACTIONALMETRICS_ON );
        g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION,RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);

        MainSeq = new Sequence("Main Sequence",0,0);
        MainSeq.setPosition(xPos,yPos);
        MainSeq.setScale(scale,scale);
        editTime = 0;
    }
    
    
        /**
     * Add a segment of text controlled by a single effect to the current presentation.
     * The time of the end of the presentation of that effect (in milliseconds from the
     * start) is returned.  (The duration of the overall presentation is the max of 
     * the values returned by calls to this method).
     */
    public static long addToPresentation(EffectSegment eff, Component canvas)
    {
        g2 = (Graphics2D)canvas.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS ,RenderingHints.VALUE_FRACTIONALMETRICS_ON );
        g2.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION,RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);

        if(eff == null){
            System.out.println("Null effect chunk!");
            return -1;
            }
        if(eff.getEffectInst() == null) {
            System.out.println("Null effect instance!");
            return -1;
        }
        //this may seem ugly, but it makes the code underneath cleaner
        //it plugs together swappable components.

        if((eff.getEffectInst()).getName().compareTo("Hop")==0)
                constructAnimation( eff,new HopInEffect(new WordSegmenter(new kinetic.util.Segment(eff.getDocument(),eff.getStartOff(),eff.getEndOff() - eff.getStartOff()))));
        if((eff.getEffectInst()).getName().compareTo("Yell")==0)
                constructAnimation( eff,new YellEffect(new WordSegmenter(new kinetic.util.Segment(eff.getDocument(),eff.getStartOff(),eff.getEndOff() - eff.getStartOff()))));
        if((eff.getEffectInst()).getName().compareTo("Construct")==0)
                constructAnimation( eff,new ConstructEffect(new LineSegmenter(new kinetic.util.Segment(eff.getDocument(),eff.getStartOff(),eff.getEndOff() - eff.getStartOff()))));
        if((eff.getEffectInst()).getName().compareTo("Slide")==0)
                constructAnimation( eff,new SlideEffect(new WordSegmenter(new kinetic.util.Segment(eff.getDocument(),eff.getStartOff(),eff.getEndOff() - eff.getStartOff()))));
        return 0;
    }
    
    /*
     *Helper function to addToPresentation that encapsulates repeated code
     */
    protected static void constructAnimation(EffectSegment eff, CompositeEffect ce){        
        //converts your types to standard types
        ParameterValue[] scottsValues = eff.getEffectInst().getParameterValues();
        Object[] myValues = new Object[scottsValues.length];
        for(int i = 0; i < scottsValues.length; i++){
            myValues[i] = scottsValues[i].getValue();
        }
        ce.setParameters(myValues);
        editTime += ce.build(MainSeq, 
            g2,initBounds,editTime);
        MainSeq.setDuration(editTime);
    }

    
    
    /**
     * Complete presentation construction and return an object that represents it.
     */
    public static Sequence endPresentation(Component canvas)
    {
        return MainSeq;
    }
    
    /**** DEAD CODE
    /** 
     * Build a complete presentation from an array of effect chucks.  This is implemented with
     * calls to beginPresentation(), addToPresentation(), endPresentation().
     *  /
    public static Sequence buildPresentation(EffectChunk[] chunkList, Component canvas)
    {

        beginPresentation(canvas);
        for (int i=0; (chunkList != null) && (i < chunkList.length); i++)
            addToPresentation(chunkList[i], canvas);
        return endPresentation(canvas);
    }
    ****  END DEAD CODE */
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /**
     * Render one frame of a presentation (representing the given point in time)
     * onto the given graphical surface.
     */
    public static void renderFrame(Sequence presentation, Component canvas, long timeMS)
    {
        // sanity check
        if (presentation == null) return;
        
        double scale = 1.0;
        double xPos = 0;
        double yPos = 0;
        setupImageBuffer(canvas);
        Rectangle newBounds = canvas.getBounds();
        double newAspectRatio = newBounds.width/newBounds.height;
        if(newAspectRatio > aspectRatio){ //the screen is wider than before
            scale = (double)newBounds.height/(double)initBounds.height;
            xPos = (newBounds.width - initBounds.width*scale)/2.0;
        }
        else{ //screen is taller than before
            scale = (double)newBounds.width/(double)initBounds.width;
            yPos = (newBounds.height - initBounds.height*scale)/2.0;
        }
        //System.out.println("Rerndering Frame at Time: " + timeMS);
        Graphics2D bufferGraphics = (Graphics2D)imageBuffer.getGraphics();
        bufferGraphics.setBackground(java.awt.Color.white);
        bufferGraphics.clearRect(0, 0, newBounds.width, newBounds.height);
        bufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        bufferGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        bufferGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS ,RenderingHints.VALUE_FRACTIONALMETRICS_ON );
        bufferGraphics.setRenderingHint(RenderingHints.KEY_RENDERING,RenderingHints.VALUE_RENDER_QUALITY);
        bufferGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        bufferGraphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION,RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        
        presentation.setPosition(xPos,yPos);
        presentation.setScale(scale,scale);
        presentation.update(timeMS);
        presentation.draw(bufferGraphics);
        
        // put the rendered frame up in one shot
        canvas.getGraphics().drawImage(imageBuffer, 0,0, null);
    }  
        
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** Build the tags list */
    protected static TagDescriptor[] buildTagsList()
    {
        if(tagsList != null)
            return tagsList;    
            
        tagNameList.clear();
        buildEffectsList();
        
        tagNameList.add("+ time");
        tagNameList.add("- time");
        TagDescriptor[] tList = new TagDescriptor[tagNameList.size()];
        for(int i = 0; i < tagNameList.size(); i++)
            tList[i] = new TagDescriptor((String)tagNameList.get(i));
        return tList;
    }
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** Build the effects list */
    protected static EffectDescriptor[] buildEffectsList()
    {
        // make sure the tags list has been built
        setDefaultEffect( generateEffectDescriptor(new HopInEffect(),new Color(0.5f,0.0f,0.0f,0.5f)));
        EffectDescriptor[] effectsList = {
            defaultEffect,
            generateEffectDescriptor(new YellEffect(),new Color(0.5f,0.5f,0.0f,0.5f)),
            generateEffectDescriptor(new ConstructEffect(),new Color(0.0f,0.5f,0.0f,0.5f)),
            generateEffectDescriptor(new SlideEffect(),new Color(0.0f,0.5f,0.5f,0.5f))
        };
        
        return effectsList;
    }

    /*
     *Helper function for getEffectsList that generates a list of properly formatted 
     *parameterDescriptor objects from a CompositeEffect
     */
    protected static ParameterDescriptor[] generateParameterDescriptors(CompositeEffect ce){
        ArrayList pList = ce.getParameterList();
        ParameterDescriptor[] pDescriptors = new ParameterDescriptor[pList.size()];
        for(int i = 0; i < pList.size(); i++){
            EffectParameter ep = (EffectParameter)pList.get(i);
            String nm = ep.getName();
            ParameterTypeDescriptor tp = null;
           
            //converts your types to my types
            switch(ep.getType()){
                /*Types that interface has:
                 *      BooleanType
                 *      DoubleRangeType
                 *      DoubleType
                 *      EnumerationType
                 *      IntegerRangeType
                 *      IntegerType
                 *      PercentageType
                 *      ZeroToOneType
                 **/

                /*Types that engine has:
                 *      Boolean
                 *      Double
                 *      Integer
                 *      Percentage
                 *      String   - not supported by interface yet
                 *      ZeroToOne
                 *      Bounded Double
                 *      Bounded Integer
                 *      Enumerated Object
                 **/

                case EffectParameter.TYPE_BOOLEAN:
                    tp = new ParameterTypeDescriptor.BooleanType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Boolean)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_DOUBLE:
                    tp = new ParameterTypeDescriptor.DoubleType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Double)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_INTEGER:
                    tp = new ParameterTypeDescriptor.IntegerType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Integer)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_PERCENTAGE:
                    tp = new ParameterTypeDescriptor.PercentageType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Double)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_ZERO_TO_ONE:
                    tp = new ParameterTypeDescriptor.ZeroToOneType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Double)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_BOUNDED_DOUBLE:
                    tp = new ParameterTypeDescriptor.DoubleRangeType(
                            ep.getName(),
                            ((EffectParameter.BoundedDouble)ep).getLowerBound(),
                            ((EffectParameter.BoundedDouble)ep).getUpperBound());  
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Double)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_BOUNDED_INTEGER:
                    tp = new ParameterTypeDescriptor.IntegerRangeType(
                            ep.getName(),
                            ((EffectParameter.BoundedInteger)ep).getLowerBound(),
                            ((EffectParameter.BoundedInteger)ep).getUpperBound());  
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Integer)ep.getDefaultObject());
                    break;
                case EffectParameter.TYPE_ENUMERATED_STRING:
                    tp = new ParameterTypeDescriptor.EnumerationType(
                            ep.getName(),
                            ((EffectParameter.EnumeratedString)ep).getChoices());  
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (String)ep.getDefaultObject());
                    break;
                default:
                    tp = new ParameterTypeDescriptor.DoubleType(ep.getName());
                    pDescriptors[i] = new ParameterDescriptor(ep.getName(), tp, (Double)ep.getDefaultObject());
                    break;
                }
            }
        return pDescriptors;
    }
    
    /*
    *Helper function for getEffectsList that generates a list of properly formatted 
    *TagDescriptor objects from a CompositeEffect
    */
    protected static TagDescriptor[] generateTagDescriptors(CompositeEffect ce){
        ArrayList tList = ce.getTagList();
        TagDescriptor[] tDescriptors = new TagDescriptor[tList.size()];
        for(int i = 0; i < tList.size(); i++){
            String tagName = (String)tList.get(i);
            boolean exists = false;
            //append to global tag list if needed
            for(int j = 0 ; j < tagNameList.size(); j++){
                if(tagName.compareTo((String)tagNameList.get(j)) == 0){
                    exists = true;
                    break;
                }
            }
            if(!exists)
                tagNameList.add(tagName);
            
            if(tagNameList.size()== 0){
                tagNameList.add(tagName);
            }
            tDescriptors[i] = new TagDescriptor(tagName);
        }
        return tDescriptors;
    }

    /*
    *Helper function for getEffectsList that generates a properly formatted 
    *EffectDescriptor object from a CompositeEffect
    */
    protected static EffectDescriptor generateEffectDescriptor(CompositeEffect ce, Color c){
        return new EffectDescriptor(ce.getName(),c, generateTagDescriptors(ce),generateParameterDescriptors(ce));
    }

    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    /* constructors */
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
    
    /** Default constructor */
    public KTEngineInterface() 
    {/* currently everything is static so we do nothing*/}
    
    /* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . */
}
