/*
 * KTEngineEventListener.java
 *
 * Created on August 30, 2002, 12:27 PM
 */

package kinetic.util;

/** interface used if you want be able to respond to even generated by the engine such as animation start, stop, finish, and new frame requests to update something like a UI
 * @author Johnny Lee
 */
public interface KTEngineEventListener{

    /** called when the animation is started
     * @param time value of the animation time when called
     */    
    public void onAnimationStart(double time);
    /** called when the animation was stopped
     * @param time value of the animation time when called
     */    
    public void onAnimationStop(double time);
    /** called when the engine reached the end of the aniamtion sequence
     * @param time value of the animation time when called
     */    
    public void onAnimationFinished(double time);
    /** call when the engine requests a new frame to be drawn
     * @param time value of the animation time when called
     */    
    public void onAnimationNewFrame(double time);
}
