/*
 * Oscillate.java
 *
 * Created on October 18, 2002, 1:57 AM
 */

package kinetic;
import java.awt.*;
import java.lang.*;
/** Oscillate behavior.  Produces cosine based change.
 *
 * @author Johnny Lee
 */
public class Oscillate extends Behavior{
    /** peak offset value
     */
    public KineticProperty amount = new KineticProperty(1);
    /** osciallation rate (radians over life span)
     */
    public KineticProperty rate = new KineticProperty(.1);
    /** radian phase shift
     */
    public KineticProperty phase = new KineticProperty(0,0,1);

    /** Creates a new instance of Oscillate
     */
    public Oscillate() {
		properties.add(amount);
		properties.add(rate);
		properties.add(phase);
    }
        /** creates a new instance of oscillate
         *@param delay_val time delay - ms
         *@param dur_val duration/lifespan - ms
         *@param amount_val peak offset amount
         *@param rate_val radians over lifespan
         *@param phase_val radian phase offset
         */
	public Oscillate(double delay_val, double dur_val, double amount_val, double rate_val, double phase_val)
		{
		this();
		amount.setValue(amount_val);
		rate.setValue(rate_val);
		duration.setValue(dur_val);
		phase.setValue(phase_val);
		addTimeFilter(new Delay(delay_val));
		}
        /** main routine to calculate the new value for the owner property
        */
    	public void Process() {
		if(owner != null) {
			if(current_time <= 0) //limits exectution
				return;
			if(current_time > duration.getEndValue()) {//limits exectution
				isDone = true;
				return;
				}
			isDone = false;
			double t = current_time/duration.getEndValue();
			owner.endValue += -amount.getEndValue() * Math.cos(rate.getEndValue()*t+ (phase.getEndValue()+1)*Math.PI/2.0);
		}
	}    
}
