package kinetic;
import java.awt.*;
import java.lang.*;

/** 
 * time filter used to easily produce repetion
 */
public class Loop extends TimeFilter{
        /** property to maintain the period of the loop - ms
         */
	public KineticProperty period = new KineticProperty(1000);
        /** create a new isntance of Loop with a given looping period -ms, lasts forever
         *@param period_val looping period -ms
         */
	public Loop(double period_val) {
		this(period_val, Double.POSITIVE_INFINITY);
	}
	/** create new instance of Loop with a given period and life span
         *@param period_val looping period - ms
         *@param dur lifespan of the loop - ms
         */
	public Loop(double period_val, double dur) {
		properties.add(period);
		period.setValue(period_val);
		duration.setValue(dur);
	}
        /** executes the timefilter on the passed value of time
         *@param time input value of time
         *@return processed value of time
         */
	public double apply(double time) {
		PrepareVariables(time);//process properties first.
		if((time < 0)||(time > duration.getEndValue())) //only valid in given range
			return time;			
		if(period.getEndValue() < 1.0)
			return 0;
		else
			return (time % period.getEndValue());
	}
}