package kinetic;
import java.awt.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.font.*;
/** 
 * creates a square that can be used in the engine and be drawn on the screen
 */

public class KineticSquare extends KineticObject{
        /** local coordinate space bounding box
         */
	protected Rectangle2D original_bounds = new Rectangle2D.Double();
	/** global coordinate space boundin box
         */
        protected GeneralPath transformed_bounds;
        /** global coordinate x
         */
	public double absoluteX;
	/** global coordinate y
         */
        public double absoluteY;
        /** creates a new instance of a KineticSquare
         */
	public KineticSquare() {
		super();
	}
        /** main draw routine
         *@param g2 graphics handle
         */
	public void draw(Graphics2D g2) {
		draw(g2, new AffineTransform());
	}
	/** main draw routin when affinte transform is provided
         *@param g2 graphics handle
         *@param ax current affine transform
         */
	public void draw(Graphics2D g2, AffineTransform ax) {
		if(!visible)
			return;

		g2.setPaint(new Color(	(float)(red.endValue),
								(float)(green.endValue),
								(float)(blue.endValue),
								(float)(alpha.endValue)));

		AffineTransform origTransform = new AffineTransform(ax);
		ax.translate(x.endValue,y.endValue);
		ax.rotate(rotation.endValue * Math.PI/180.0);
		ax.shear(xShear.endValue, yShear.endValue);
		
		//center text---------------
		double x2 = xScale.getEndValue()/2.0;
                double y2 = yScale.getEndValue()/2.0;
		original_bounds.setRect(-x2,-y2, xScale.getEndValue(), yScale.getEndValue());

		GeneralPath gp = new GeneralPath(original_bounds);
		transformed_bounds = (GeneralPath)gp.createTransformedShape(ax);
		
		Rectangle bbox = transformed_bounds.getBounds();
		absoluteX = bbox.getX() + bbox.getWidth()/2.0;
		absoluteY = bbox.getY() + bbox.getHeight()/2.0;

		g2.setTransform(ax);
		
		g2.fill(original_bounds);
		
		ax.setTransform(origTransform);
	}
	/** gets global coordinate boundin box
         *@return global coordinate bbox
         */
	public Rectangle2D getBounds(){
		return transformed_bounds.getBounds();
		}
	/** hits test
         *@param p hit point
         *@return true if contains point
         */
	public boolean contains(Point p) {
            if(transformed_bounds == null)
                    return false;
            else
                    return transformed_bounds.contains(p.getX(),p.getY());
	}
	/** get width of global coordinate BBox
         *@return width
         */
	public double getWidth() {
		return transformed_bounds.getBounds().getWidth();
	}
        /** get width of global coordinate BBox
         *@return height
         */
	public double getHeight() {
		return transformed_bounds.getBounds().getHeight();
	}
	
        /** get global coordinate x
         *@return x position
         */
	public double getAbsoluteX() {
		return absoluteX;
	}
	/** get global coordinate y
         *@return y position
         */
	public double getAbsoluteY() {
		return absoluteY;
	}
}
