#include "llvm/Pass.h"
#include "llvm/Function.h"
#include "llvm/Module.h"
#include "llvm/Instructions.h"
#include "llvm/Support/CallSite.h"
#include "llvm/Support/raw_ostream.h"

#include "llvm/Analysis/Passes.h"
#include "llvm/Function.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/ErrorHandling.h"
#include "llvm/Support/InstVisitor.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Instruction.def"

#include "llvm/PassManagers.h"
#include "llvm/Instructions.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/Analysis/Dominators.h"
#include "llvm/Support/InstIterator.h"
#include "llvm/Support/CFG.h"
#include "llvm/Support/raw_ostream.h"

#include <list>
#include <ostream>
#include <fstream>
#include <iostream>

using namespace std;

using namespace llvm;

namespace {

  class LICMPass : public LoopPass {
  public:
    static char ID;
    
    LICMPass() : LoopPass (ID) {}
    ~LICMPass() {}

    //unsigned dep=0;
    
    // I don't think the LoopInfo pass is doing anything, but I am afraid to remove
    // it in case it breaks something :)
    // We require the DominatorTree pass to avoid moving code that does not dominate
    // all possible exits.
    virtual void getAnalysisUsage(AnalysisUsage &AU) const {
      AU.addRequired<LoopInfo>();
      AU.addRequired<DominatorTree>();
      //AU.setPreservesAll();
    }
    
    // Main pass function that does everything.
    virtual bool runOnLoop(Loop *L, LPPassManager &LPM) { 
      int numinst =0;
      cout << L->getLoopDepth() << endl;
      const std::vector<BasicBlock*> blocks = L->getBlocks();
        for (int b=0; b < blocks.size(); b++ ) {
	 BasicBlock* currentblock = blocks[b];
         for (BasicBlock::iterator i = currentblock->begin(), ie = currentblock->end(); i != ie; ++i) {
	    numinst++;
         }
        }
      cout << numinst << endl;
      //ofstream myfile;
      //myfile.open ("example.txt");
      //myfile << L->getLoopDepth() << endl;
      //myfile.close();
     
      //cout << "Depth:" << L->getLoopDepth() << endl;
      //if(dep < L->getLoopDepth()){dep = L->getLoopDepth();}
    }
  };
  

char LICMPass::ID = 0;
RegisterPass<LICMPass> X("loops-info", "15745: Loops Information");
}
