import os
import sys

# Takes grep test and puts it in csv format
# The grep test gets all the execution times for the orderings

PREFIX = "SingleSource/Benchmarks/"

TESTS = {"Dhrystone": ("dry", "fldry"),
         "BenchmarkGame": ("fannkuch", "n-body", "nsieve-bits", "partialsums", "puzzle", "recursive", "spectral-norm"),
         "Shootout" : ("ackermann", "ary3", "fib2", "hash", "heapsort", "hello", "lists", "matrix", "methcall", "objinst", "random", "sieve", "strcat"),
         "Adobe-C++" : ("loop_unroll", "simple_types_constant_folding", "simple_types_loop_invariant"),
         "McGill" : ("misr",),
         "Misc" : ("dt", "fbench", "ffbench", "flops-1", "flops-2", "flops-3", "flops-4", "flops-5", "flops-6", "flops-7", "flops-8", "fp-convert", "himenobmtxpa", "lowercase", "mandel", "oourafft", "perlin", "pi", "ReedSolomon", "salsa20"),
         "Misc-C++" : ("bigfib", "mandel-text"),
         "Misc-C++/Large" : ("ray", "sphereflake"),
         "Shootout-C++" : ("ary", "ary2", "ary3", "fibo", "hash", "heapsort", "hello", "matrix", "methcall", "objinst", "random", "reversefile", "sieve", "spellcheck", "strcat", "sumcol", "wc"),
         "Stanford" : ("Bubblesort","FloatMM","IntMM","Oscar","Perm", "Quicksort", "RealMM", "Towers", "Treesort")
         }

csvResult = []
nTests = 0
for BENCHMARK, TEST_LIST in TESTS.iteritems():
  for TEST in TEST_LIST:
    init = [BENCHMARK + "/" + TEST]
    csvResult.append(init)
    nTests = nTests + 1
  
i = 0
for BENCHMARK, TEST_LIST in TESTS.iteritems():
  for TEST in TEST_LIST:
    filename = PREFIX + BENCHMARK + "/test.grep." + TEST
    fi = open(filename, "r")
    for line in fi:
      csvResult[i].append(line.rstrip())
    fi.close()
    i = i + 1
    
for l in csvResult:
  printLine = l[0]
  for i in range(len(l) - 1):
    printLine = printLine + ", " + str(l[i+1])
  print printLine
