#!/bin/bash

shopt -s lastpipe

INPUT_FILE="orderings"
ITERATION_FILE="iter"
OUTPUT_FILE="ordering"

BENCHMARK="BenchmarkGame/Large"

python orderings.py > ${INPUT_FILE}

i="0"
while read line
do
  rm -f ${OUTPUT_FILE}
  for pfile in ${line}
  do
    cat ${pfile} >> ${OUTPUT_FILE}
    echo -n " " >> ${OUTPUT_FILE}
  done
  echo $i > ${ITERATION_FILE}
  echo `cat ${ITERATION_FILE}` : ${line}
  make -C ./SingleSource/Benchmarks/${BENCHMARK} TEST=crap < /dev/null
  i=$(($i + 1))
done < ${INPUT_FILE}

rm ${INPUT_FILE} ${ITERATION_FILE} ${OUTPUT_FILE}