import os
import sys

PREFIX = "SingleSource/Benchmarks/"

TESTS = {"Dhrystone": ("dry", "fldry"),
         "BenchmarkGame": ("fannkuch", "n-body", "nsieve-bits", "partialsums", "puzzle", "recursive", "spectral-norm"),
         "Shootout" : ("ackermann", "ary3", "fib2", "hash", "heapsort", "hello", "lists", "matrix", "methcall", "objinst", "random", "sieve", "strcat"),
         "Adobe-C++" : ("loop_unroll", "simple_types_constant_folding", "simple_types_loop_invariant"),
         "McGill" : ("misr",),
         "Misc" : ("dt", "fbench", "ffbench", "flops-1", "flops-2", "flops-3", "flops-4", "flops-5", "flops-6", "flops-7", "flops-8", "fp-convert", "himenobmtxpa", "lowercase", "mandel", "oourafft", "perlin", "pi", "ReedSolomon", "salsa20"),
         "Misc-C++" : ("bigfib", "mandel-text"),
         "Misc-C++/Large" : ("ray", "sphereflake"),
         "Shootout-C++" : ("ary", "ary2", "ary3", "fibo", "hash", "heapsort", "hello", "matrix", "methcall", "objinst", "random", "reversefile", "sieve", "spellcheck", "strcat", "sumcol", "wc"),
         "Stanford" : ("Bubblesort","FloatMM","IntMM","Oscar","Perm", "Quicksort", "RealMM", "Towers", "Treesort")
         }

FEATURE_NAMES = ("aaeval", "countBlocks", "instcount", "lda", "regions", "whatever2")

TEST_SIZE = (10, 1, 52, 3, 2, 3)

csvResult = []
nTests = 0
for BENCHMARK, TEST_LIST in TESTS.iteritems():
  for TEST in TEST_LIST:
    init = [BENCHMARK + "/" + TEST]
    csvResult.append(init)
    nTests = nTests + 1
  
i = 0
for BENCHMARK, TEST_LIST in TESTS.iteritems():
  for TEST in TEST_LIST:
    for f in range(len(FEATURE_NAMES)):
      nLines = 0
      try:
        filename = PREFIX + BENCHMARK + "/test."+FEATURE_NAMES[f]+"." + TEST
        fi = open(filename, "r")
        for line in fi:
          csvResult[i].append(line.rstrip())
          nLines = nLines + 1
        fi.close()
      except IOError as e:
        print >> sys.stderr, "Could not find " + filename
      
      if nLines != TEST_SIZE[f] and TEST_SIZE[f] > 0:
        print >> sys.stderr, "Non-default size for "+FEATURE_NAMES[f]
      # In case not all lines were in, pad results, but print a warning
      # This is only supposed to happen for "regions", "lda" and "whatever2"
      if TEST_SIZE[f] > nLines:
        print >> sys.stderr, "Padding... "+FEATURE_NAMES[f]
      for pad in range(TEST_SIZE[f] - nLines):
        csvResult[i].append(0)
      
      
      
      csvResult[i].append("@@")
    i = i + 1

for l in csvResult:
  printLine = l[0]
  for i in range(len(l) - 1):
    printLine = printLine + ", " + str(l[i+1])
  print printLine
    
    

#fi = open(sys.argv[1], "r")

#total = 0
#for line in fi:
#  total = total + float(line)

#fi.close()

#print total