##===- TEST.feature-extraction.Makefile ------------------------------*- Makefile -*-===##
#
###############
# J-Dawg AKA "The Bladderman"
###################
# This recursively traverses the programs, and runs the -simplify-libcalls pass
# on each *.linked.rbc bytecode file with -stats set so that it is possible to
# determine which libcalls are being optimized in which programs.
# 
# Usage: 
#### NOT FUNCTIONAL     make TEST=feature-extraction summary (short summary)
#     make TEST=feature-extraction (detailed list with time passes, etc.)
#     make TEST=feature-extraction report
#     make TEST=feature-extraction report.html
#
##===----------------------------------------------------------------------===##

CURDIR  := $(shell cd .; pwd)
PROGDIR := $(PROJ_SRC_ROOT)
RELDIR  := $(subst $(PROGDIR),,$(CURDIR))

OPT_CRAP:= -stats -regions

TEST_NAME = $*

$(PROGRAMS_TO_TEST:%=test.$(TEST).%) : test.$(TEST).% : Output/%.bc $@ $(PROJ_SRC_ROOT)/TEST.$(TEST).Makefile
	@echo Doing $<
	@$(LOPT) $(OPT_CRAP) $< -o $(TEST_NAME).dirt.o 2> $@.tmp
	@-cat $@.tmp | sed -e "s/ *\([0-9]*\).*/\1/g" | grep [0-9] > $@
#	@-cat $@.tmp > $@
	@rm -f $@.tmp

REPORT_DEPENDENCIES := $(LOPT)