##===- TEST.feature-extraction.Makefile ------------------------------*- Makefile -*-===##
#
###############
# J-Dawg AKA "The Bladderman"
###################
# This recursively traverses the programs, and runs the -simplify-libcalls pass
# on each *.linked.rbc bytecode file with -stats set so that it is possible to
# determine which libcalls are being optimized in which programs.
# 
# Usage: 
#### NOT FUNCTIONAL     make TEST=feature-extraction summary (short summary)
#     make TEST=feature-extraction (detailed list with time passes, etc.)
#     make TEST=feature-extraction report
#     make TEST=feature-extraction report.html
#
##===----------------------------------------------------------------------===##

OPTIM:=-O3

CURDIR  := $(shell cd .; pwd)
PROGDIR := $(PROJ_SRC_ROOT)
RELDIR  := $(subst $(PROGDIR),,$(CURDIR))

TEST_NAME = $*

$(PROGRAMS_TO_TEST:%=Output/%.opt.exe) : Output/%.opt.exe : Output/%.bc $(LOPT) $(PROJ_SRC_ROOT)/TEST.$(TEST).Makefile \
																												$(PROJ_SRC_ROOT)/$(ITERATION_FILE) $(PROJ_SRC_ROOT)/$(OUTPUT_FILE)
	@echo Compiling $(TEST_NAME) to $@ for test $(TEST)
	@$(LOPT) $(OPTIM) $< -o $(TEST_NAME).opt.o
	@$(LLVMLD) $(TEST_NAME).opt.o -o=$@
	@-rm $(TEST_NAME).opt.o

$(PROGRAMS_TO_TEST:%=test.$(TEST).%) : test.$(TEST).% : Output/%.opt.exe $@ $(PROJ_SRC_ROOT)/TEST.$(TEST).Makefile \
																												$(PROJ_SRC_ROOT)/$(ITERATION_FILE) $(PROJ_SRC_ROOT)/$(OUTPUT_FILE)
	@echo Timing Output/$(TEST_NAME).opt.exe
	@rm -f $@
	@-for number in 1 2 3 4 5; do \
		(bash -c "time Output/$*.opt.exe" > /dev/null 2>> $@) ; \
		echo -n . ; \
	done
#	@-(bash -c "time Output/$*.opt.exe") > /dev/null 2>> $@
#	@echo -n .
#	@-(bash -c "time Output/$*.opt.exe" 2>&1) >> $@
#	@echo -n .
	@echo 

REPORT_DEPENDENCIES := $(LOPT)