
import direct.directbase.DirectStart
from direct.showbase.ShowBaseGlobal import *
from direct.distributed.DistributedObject import *
from direct.distributed.ClientRepository import *
from direct.distributed.ServerRepository import *
from direct.interval.IntervalGlobal import *
from direct.gui.DirectGui import DirectLabel
from random import randint,uniform
import sys

ARENASIZE=100

class Lights:
  def __init__(self):
    orbit = 30
    self.centers = []
    self.axes = []
    self.lights = []
    self.paths = []
    attrib = LightAttrib.makeAllOff()
    for i in range(8):
      center = NodePath("orbitcenter")
      center.setPos(uniform(-ARENASIZE,ARENASIZE),uniform(-ARENASIZE,ARENASIZE),uniform(-ARENASIZE,ARENASIZE))
      center.setHpr(uniform(-360,360),uniform(-360,360),uniform(-360,360))
      center.reparentTo(render)
      axis = NodePath("orbitaxis")
      axis.reparentTo(center)
      light = PointLight("pointlight")
      light.setColor(Vec4(uniform(0.2,0.4),uniform(0.2,0.4),uniform(0.2,0.4),1.0))
      light.setAttenuation(Vec3(0.8,0.02,0.0))
      path = axis.attachNewNode(light.upcastToPandaNode())
      path.setPos(orbit,0,0)
      self.centers.append(center)
      self.axes.append(axis)
      self.lights.append(light)
      self.paths.append(path)
      attrib = attrib.addLight(light)
    self.attrib = attrib
    render.node().setAttrib(attrib)
    taskMgr.add(self.orbitLights,"orbitLights")

  def orbitLights(self,task):
    for x in self.axes:
      x.setHpr(5*task.time,0,0)
    return Task.cont


class Pylon:

  def __init__(self):
    sizex = uniform(ARENASIZE*0.8,ARENASIZE*1.3)*0.5
    sizey = uniform(ARENASIZE*0.6,ARENASIZE*0.9)*0.5
    sizez = uniform(ARENASIZE*0.1,ARENASIZE*0.2)*0.5
    if (randint(0,1)): (sizex,sizey) = (sizey,sizex)
    if (randint(0,1)): (sizex,sizez) = (sizez,sizex)
    if (randint(0,1)): (sizey,sizez) = (sizez,sizey)
    centerx = uniform(-ARENASIZE,ARENASIZE)
    centery = uniform(-ARENASIZE,ARENASIZE)
    centerz = uniform(-ARENASIZE,ARENASIZE)
    if (centerx < sizex - ARENASIZE): centerx = sizex - ARENASIZE
    if (centerx > ARENASIZE - sizex): centerx = ARENASIZE - sizex
    if (centery < sizey - ARENASIZE): centery = sizey - ARENASIZE
    if (centery > ARENASIZE - sizey): centery = ARENASIZE - sizey
    if (centerz < sizez - ARENASIZE): centerz = sizez - ARENASIZE
    if (centerz > ARENASIZE - sizez): centerz = ARENASIZE - sizez
    self.x1 = centerx - sizex
    self.y1 = centery - sizey
    self.z1 = centerz - sizez
    self.x2 = centerx + sizex
    self.y2 = centery + sizey
    self.z2 = centerz + sizez
    self.model = loader.loadModelCopy("cube")
    self.model.reparentTo(render)
    self.model.setScale(sizex*2,sizey*2,sizez*2)
    self.model.setPos(centerx,centery,centerz)

class Arena:
  
  def __init__(self):
    self.model = loader.loadModelCopy("icube")
    self.model.reparentTo(render)
    self.model.setScale(ARENASIZE*2,ARENASIZE*2,ARENASIZE*2)


class Spaceship(DirectObject):
  
  def __init__(self):
    self.model = loader.loadModel("ship")
    self.model.reparentTo(render)
    self.alt = NodePath("altship")
    self.alt.reparentTo(self.model)
    self.pos = Point3(0,0,0)
    self.vel = Vec3(0,0,0.1)
    self.keys = {}
    self.keys["left"] = 0
    self.keys["right"] = 0
    self.keys["up"] = 0
    self.keys["down"] = 0
    self.keys["c"] = 0
    self.last = 0
    self.accept("c",self.setKey,["c",1])
    self.accept("c-up",self.setKey,["c",0])
    self.accept("arrow_left",self.setKey,["left",1])
    self.accept("arrow_right",self.setKey,["right",1])
    self.accept("arrow_left-up",self.setKey,["left",0])
    self.accept("arrow_right-up",self.setKey,["right",0])
    self.accept("arrow_up",self.setKey,["up",1])
    self.accept("arrow_down",self.setKey,["down",1])
    self.accept("arrow_up-up",self.setKey,["up",0])
    self.accept("arrow_down-up",self.setKey,["down",0])
    taskMgr.add(self.fly,"fly")
  
  def setKey(self,key,val):
    self.keys[key] = val
 
  def fly(self,task):
    elapsed = task.time - self.last
    head = 0
    pitch = 0
    if (self.keys["left"]):  head -= elapsed*0.1
    if (self.keys["right"]): head += elapsed*0.1
    if (self.keys["up"]):    pitch -= elapsed*0.1
    if (self.keys["down"]):  pitch += elapsed*0.1
    self.alt.setHpr(0,pitch,head)
    trans = self.alt.getNetTransform()
    self.model.setTransform(trans)
    self.vel = Vec3(self.vel * (1.0 - (elapsed*0.01)))
    if (self.keys["c"]):
      dir = self.model.getMat().getRow3(2)
      self.vel = Vec3(self.vel + dir * (elapsed*0.1))
      len = self.vel.length()
      if (len > 1.0): self.vel.normalize()
    self.model.setPos(self.model.getPos() + self.vel*(elapsed*0.1))
    self.last = elapsed
    return Task.cont

theship = Spaceship()
thearena = Arena()
thepylons = [Pylon() for i in range(2)]
thelights = Lights()
base.disableMouse()
base.camLens.setFov(80,80*0.75)
base.camera.reparentTo(theship.model)
base.camera.setPos(0,0,-20)
base.camera.lookAt(theship.model)
base.camera.setPos(0,-5,-20)


run()

