from mocap import *

########################################################################################################
#
# Sample code using playback engine from mocap.py
#
########################################################################################################

def usage():
  errorexit("Usage: ppython amcviewer.py 0/1 file.amc")

if (len(sys.argv) != 3): usage()

woman = mocapActor("woman42")
woman.reparentTo(render)
#woman.setScale(1.0/36.0)
woman.setScale(1.0/30.0)
woman.setPos(0.0,0.0,3.0) # no effect changing this
woman.loop("idle")

floor = loader.loadModel("floor")
floor.reparentTo(render)
floor.setScale(1.0)
#floor.setPos(0.0,0.0,0.0)
floor.setPos(0.0,0.0,-0.3)

y_up = loader.loadModel("yup-axis")
y_up.reparentTo(render)
y_up.setScale(0.1)
y_up.setPos(0.0,0.0,0.0)

# comment out disableMouse() to change camera angles with mouse
# but setPos and lookAt doesn't seem to have affect
base.disableMouse()
base.camera.setPos(-10,-25,10)
base.camera.lookAt(0.0,0.0,0.0)
#base.camera.setPos(-8,-20,8)
#base.camera.lookAt(0.0,0.0,3.0)

allframes = readMocapFile(sys.argv[2])

# start at first frame
woman.applyMocapFrame(allframes[0])

frameRate = 120.0
frameRateLabel = DirectLabel(text=str(frameRate)+' Hz',scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-0.45,0.0,-0.95))

class keyboardPress(DirectObject.DirectObject):
  def __init__(self):
    self.currentFrame = 0
    self.accept('arrow_left',self.key_arrowLeft)
    self.accept('arrow_right',self.key_arrowRight)
    self.accept('space',self.key_space)
    self.tempindex = 0
    self.spaceEvenOdd = 0
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def getStr(self,i):
    if ((0 <= i) and (i <= 9)):
      return ('000'+str(i))
    elif ((10 <= i) and (i <= 99)):
      return ('00'+str(i))
    elif ((100 <= i) and (i <= 999)):
      return ('0'+str(i))
    else:
      return (str(i))

  def key_arrowLeft(self):
    self.currentFrame -= 1
    if (self.currentFrame == -1):
      self.currentFrame = len(allframes) - 1
    woman.applyMocapFrame(allframes[self.currentFrame])
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def key_arrowRight(self):
    self.currentFrame += 1
    if (self.currentFrame == len(allframes)):
      self.currentFrame = 0
    woman.applyMocapFrame(allframes[self.currentFrame])
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def key_space(self):
    if (self.spaceEvenOdd == 0):
      self.spaceEvenOdd = 1
      def playLoop(task):
        if (task.time == 0.0):
          self.tempindex = self.currentFrame
          woman.applyMocapFrame(allframes[self.tempindex])
          self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))
        else:
          frameindex = ( int(task.time * frameRate) + self.tempindex ) % len(allframes)
          woman.applyMocapFrame(allframes[frameindex])
          self.currentFrame = frameindex
          self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))
        return Task.cont
      taskMgr.add(playLoop,"playLoop")
    else:
      self.spaceEvenOdd = 0
      taskMgr.remove("playLoop")

kpress = keyboardPress()

# (floor_x_amc,floor_z_amc) gives you the path in the coordinate system corresponding to the data in the amc files
# floor_y_amc is not necessary

class mousePress(DirectObject.DirectObject):
  def __init__(self):
    self.accept('mouse1',self.mouse_left)
    self.accept('mouse1-up',self.mouse_left_up)

  def mouse_left(self):
    def playLoopMouse(task):
      if base.mouseWatcherNode.hasMouse():
	fov = base.camNode.getLens().getFov()
	aspect = base.camNode.getLens().getAspectRatio()
        screen_x = base.mouseWatcherNode.getMouseX() * aspect
        screen_y = base.mouseWatcherNode.getMouseY()
	screen_z = 1.0 / math.tan(fov.getY()*0.5*(math.pi/180.0))
	cam_mat = base.camera.getMat()
	vec_0 = cam_mat.getRow3(0)
	vec_1 = cam_mat.getRow3(1)
	vec_2 = cam_mat.getRow3(2)
	ray = vec_0 * screen_x + vec_2 * screen_y + vec_1 * screen_z

	# -0.3 is hardcoded above for the floor's position
	# if you change that, you need to change it here too
	k = (-0.3-base.camera.getZ()) / ray.getZ()
	floor_x_panda = base.camera.getX() + ray.getX() * k
	floor_y_panda = base.camera.getY() + ray.getY() * k
	floor_z_panda = -0.3

	sphere = loader.loadModelCopy("sphere")
	sphere.reparentTo(render)
	sphere.setScale(0.1)
	sphere.setPos(floor_x_panda,floor_y_panda,floor_z_panda)

        floor_x_amc = 5.0 * floor_x_panda
        floor_z_amc = -5.0 * floor_y_panda
#        print ("floor_x_amc "+str(floor_x_amc)+"   floor_z_amc "+str(floor_z_amc))
      return Task.cont
    taskMgr.add(playLoopMouse,"playLoopMouse")

  def mouse_left_up(self):
    taskMgr.remove("playLoopMouse")

if (int(sys.argv[1]) == 1):
  mpress = mousePress()

run()
