import sys,os,time,string
import math

#######################################################################
#
# vector operations
#
#######################################################################

class vector:
  def __init__(self,x,y,z):
    self.x = x
    self.y = y
    self.z = z

  def assign_v(self,x,y,z):
    self.x = x
    self.y = y
    self.z = z

  def ret_list(self):
    return [self.x,self.y,self.z]

  def printV(self):
    print ('vector ['+str(self.x)+', '+str(self.y)+', '+str(self.z)+']')

  def add(self,v):
    newV = vector(0.0,0.0,0.0)
    newV.x = self.x + v.x
    newV.y = self.y + v.y
    newV.z = self.z + v.z
    return newV

  def sub(self,v):
    newV = vector(0.0,0.0,0.0)
    newV.x = self.x - v.x
    newV.y = self.y - v.y
    newV.z = self.z - v.z
    return newV

  def dot(self,v):
    return (self.x * v.x + self.y * v.y + self.z * v.z)

  def cross(self,v):
    newV = vector(0.0,0.0,0.0)
    newV.x = self.y * v.z - self.z * v.y
    newV.y = self.z * v.x - self.x * v.z
    newV.z = self.x * v.y - self.y * v.x
    return newV

  def scalMul(self,m):
    newV = vector(0.0,0.0,0.0)
    newV.x = self.x * m
    newV.y = self.y * m
    newV.z = self.z * m
    return newV

  def scalDiv(self,m):
    newV = vector(0.0,0.0,0.0)
    newV.x = self.x / m
    newV.y = self.y / m
    newV.z = self.z / m
    return newV

  def length(self):
    return math.sqrt(self.x * self.x + self.y * self.y + self.z * self.z)

  def norm(self):
    newV = vector(0.0,0.0,0.0)
    m = math.sqrt(self.x * self.x + self.y * self.y + self.z * self.z)
    newV.x = self.x / m
    newV.y = self.y / m
    newV.z = self.z / m
    return newV
