from vector import *

#######################################################################
#
# matrix operations
#
#######################################################################

class matrix:
  def __init__(self,m00,m01,m02,m10,m11,m12,m20,m21,m22):
    self.m00 = m00
    self.m01 = m01
    self.m02 = m02
    self.m10 = m10
    self.m11 = m11
    self.m12 = m12
    self.m20 = m20
    self.m21 = m21
    self.m22 = m22

  def assign_m(self,m00,m01,m02,m10,m11,m12,m20,m21,m22):
    self.m00 = m00
    self.m01 = m01
    self.m02 = m02
    self.m10 = m10
    self.m11 = m11
    self.m12 = m12
    self.m20 = m20
    self.m21 = m21
    self.m22 = m22

  def ret_listoflist(self):
    return [[self.m00,self.m01,self.m02],[self.m10,self.m11,self.m12],[self.m20,self.m21,self.m22]]

  def printM(self):
    print ('matrix ['+str(self.m00)+', '+str(self.m01)+', '+str(self.m02))
    print ('        '+str(self.m10)+', '+str(self.m11)+', '+str(self.m12))
    print ('        '+str(self.m20)+', '+str(self.m21)+', '+str(self.m22)+']')

  def transpose(self):
    newM = matrix(0,0,0,0,0,0,0,0,0)
    newM.m00 = self.m00; newM.m01 = self.m10; newM.m02 = self.m20
    newM.m10 = self.m01; newM.m11 = self.m11; newM.m12 = self.m21
    newM.m20 = self.m02; newM.m21 = self.m12; newM.m22 = self.m22
    return newM

  def multV(self,v):
    newV = vector(0,0,0)
    newV.x = self.m00 * v.x + self.m01 * v.y + self.m02 * v.z
    newV.y = self.m10 * v.x + self.m11 * v.y + self.m12 * v.z
    newV.z = self.m20 * v.x + self.m21 * v.y + self.m22 * v.z
    return newV

  def multM(self,m):
    newM = matrix(0,0,0,0,0,0,0,0,0)
    newM.m00 = self.m00 * m.m00 + self.m01 * m.m10 + self.m02 * m.m20
    newM.m01 = self.m00 * m.m01 + self.m01 * m.m11 + self.m02 * m.m21
    newM.m02 = self.m00 * m.m02 + self.m01 * m.m12 + self.m02 * m.m22

    newM.m10 = self.m10 * m.m00 + self.m11 * m.m10 + self.m12 * m.m20
    newM.m11 = self.m10 * m.m01 + self.m11 * m.m11 + self.m12 * m.m21
    newM.m12 = self.m10 * m.m02 + self.m11 * m.m12 + self.m12 * m.m22

    newM.m20 = self.m20 * m.m00 + self.m21 * m.m10 + self.m22 * m.m20
    newM.m21 = self.m20 * m.m01 + self.m21 * m.m11 + self.m22 * m.m21
    newM.m22 = self.m20 * m.m02 + self.m21 * m.m12 + self.m22 * m.m22
    return newM

  def rotationZ(self,angle):
    a = angle * 3.14159265 / 180.0
    self.m00 = math.cos(a); self.m01 = -math.sin(a); self.m02 = 0.0
    self.m10 = math.sin(a); self.m11 = math.cos(a);  self.m12 = 0.0
    self.m20 = 0.0;         self.m21 = 0.0;          self.m22 = 0.0

  def rotationY(self,angle):
    a = angle * 3.14159265 / 180.0
    self.m00 = math.cos(a);  self.m01 = 0.0; self.m02 = math.sin(a)
    self.m10 = 0.0;          self.m11 = 1.0; self.m12 = 0.0
    self.m20 = -math.sin(a); self.m21 = 0.0; self.m22 = math.cos(a)

  def rotationX(self,angle):
    a = angle * 3.14159265 / 180.0
    self.m00 = 1.0; self.m01 = 0.0;         self.m02 = 0.0
    self.m10 = 0.0; self.m11 = math.cos(a); self.m12 = -math.sin(a)
    self.m20 = 0.0; self.m21 = math.sin(a); self.m22 = math.cos(a)
