from mocap import *

########################################################################################################
#
# Sample code using playback engine from mocap.py
#
########################################################################################################

def usage():
  errorexit("Usage: ppython amcviewer.py file.amc")

if (len(sys.argv) != 2): usage()

woman = mocapActor("woman42")
woman.reparentTo(render)
#woman.setScale(1.0/36.0)
woman.setScale(1.0/30.0)
woman.setPos(0.0,0.0,3.0) # no effect changing this
woman.loop("idle")

floor = loader.loadModel("floor")
floor.reparentTo(render)
floor.setScale(1.0)
#floor.setPos(0.0,0.0,0.0)
floor.setPos(0.0,0.0,-0.3)

y_up = loader.loadModel("yup-axis")
y_up.reparentTo(render)
y_up.setScale(0.1)
y_up.setPos(0.0,0.0,0.0)

# comment out disableMouse() to change camera angles with mouse
# but setPos and lookAt doesn't seem to have affect
base.disableMouse()
base.camera.setPos(-10,-25,10)
base.camera.lookAt(0.0,0.0,0.0)
#base.camera.setPos(-8,-20,8)
#base.camera.lookAt(0.0,0.0,3.0)

allframes = readMocapFile(sys.argv[1])

# start at first frame
woman.applyMocapFrame(allframes[0])

frameRate = 120.0
frameRateLabel = DirectLabel(text=str(frameRate)+' Hz',scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-0.45,0.0,-0.95))

class keyboardPress(DirectObject.DirectObject):
  def __init__(self):
    self.currentFrame = 0
    self.accept('arrow_left',self.key_arrowLeft)
    self.accept('arrow_right',self.key_arrowRight)
    self.accept('space',self.key_space)
    self.tempindex = 0
    self.spaceEvenOdd = 0
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def getStr(self,i):
    if ((0 <= i) and (i <= 9)):
      return ('000'+str(i))
    elif ((10 <= i) and (i <= 99)):
      return ('00'+str(i))
    elif ((100 <= i) and (i <= 999)):
      return ('0'+str(i))
    else:
      return (str(i))

  def key_arrowLeft(self):
    self.currentFrame -= 1
    if (self.currentFrame == -1):
      self.currentFrame = len(allframes) - 1
    woman.applyMocapFrame(allframes[self.currentFrame])
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def key_arrowRight(self):
    self.currentFrame += 1
    if (self.currentFrame == len(allframes)):
      self.currentFrame = 0
    woman.applyMocapFrame(allframes[self.currentFrame])
    self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))

  def key_space(self):
    if (self.spaceEvenOdd == 0):
      self.spaceEvenOdd = 1
      def playLoop(task):
        if (task.time == 0.0):
          self.tempindex = self.currentFrame
          woman.applyMocapFrame(allframes[self.tempindex])
          self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))
        else:
          frameindex = ( int(task.time * frameRate) + self.tempindex ) % len(allframes)
          woman.applyMocapFrame(allframes[frameindex])
          self.currentFrame = frameindex
          self.frameLabel = DirectLabel(text='Frame '+self.getStr(self.currentFrame+1)+' of '+str(len(allframes)),scale=(0.3,0.3,0.3),text_scale=(0.3,0.3),pos=(-1.0,0.0,-0.95))
        return Task.cont
      taskMgr.add(playLoop,"playLoop")
    else:
      self.spaceEvenOdd = 0
      taskMgr.remove("playLoop")

kpress = keyboardPress()

run()
