import sys,os,time,string

#######################################################################
#
# writes amc file from a list of lists
# self.rawdata[][] - first [] indexes frame number starting at 0
#                  - second [] indexes pos/joint value 0 to 61
# WARNING:  write_file() appends to file with same name (if exists)
#
#######################################################################

class amcWriter:
  def __init__(self,data):
    self.rawdata = data

  def write_file(self,fname):
    f = open(fname, 'a')

    f.write('#!OML:ASF written by write_file() in amcWriter\n')
    f.write(':FULLY-SPECIFIED\n')
    f.write(':DEGREES\n')

    for i in range(len(self.rawdata)):
      f.write(str(i+1)+'\n')
      f.write('root '+str(self.rawdata[i][0])+' '+str(self.rawdata[i][1])+' '+str(self.rawdata[i][2])+' '+str(self.rawdata[i][3])+' '+str(self.rawdata[i][4])+' '+str(self.rawdata[i][5])+'\n')

      f.write('lowerback '+str(self.rawdata[i][6])+' '+str(self.rawdata[i][7])+' '+str(self.rawdata[i][8])+'\n')
      f.write('upperback '+str(self.rawdata[i][9])+' '+str(self.rawdata[i][10])+' '+str(self.rawdata[i][11])+'\n')
      f.write('thorax '+str(self.rawdata[i][12])+' '+str(self.rawdata[i][13])+' '+str(self.rawdata[i][14])+'\n')
      f.write('lowerneck '+str(self.rawdata[i][15])+' '+str(self.rawdata[i][16])+' '+str(self.rawdata[i][17])+'\n')
      f.write('upperneck '+str(self.rawdata[i][18])+' '+str(self.rawdata[i][19])+' '+str(self.rawdata[i][20])+'\n')
      f.write('head '+str(self.rawdata[i][21])+' '+str(self.rawdata[i][22])+' '+str(self.rawdata[i][23])+'\n')

      f.write('rclavicle '+str(self.rawdata[i][24])+' '+str(self.rawdata[i][25])+'\n')
      f.write('rhumerus '+str(self.rawdata[i][26])+' '+str(self.rawdata[i][27])+' '+str(self.rawdata[i][28])+'\n')
      f.write('rradius '+str(self.rawdata[i][29])+'\n')
      f.write('rwrist '+str(self.rawdata[i][30])+'\n')
      f.write('rhand '+str(self.rawdata[i][31])+' '+str(self.rawdata[i][32])+'\n')
      f.write('rfingers '+str(self.rawdata[i][33])+'\n')
      f.write('rthumb '+str(self.rawdata[i][34])+' '+str(self.rawdata[i][35])+'\n')

      f.write('lclavicle '+str(self.rawdata[i][36])+' '+str(self.rawdata[i][37])+'\n')
      f.write('lhumerus '+str(self.rawdata[i][38])+' '+str(self.rawdata[i][39])+' '+str(self.rawdata[i][40])+'\n')
      f.write('lradius '+str(self.rawdata[i][41])+'\n')
      f.write('lwrist '+str(self.rawdata[i][42])+'\n')
      f.write('lhand '+str(self.rawdata[i][43])+' '+str(self.rawdata[i][44])+'\n')
      f.write('lfingers '+str(self.rawdata[i][45])+'\n')
      f.write('lthumb '+str(self.rawdata[i][46])+' '+str(self.rawdata[i][47])+'\n')

      f.write('rfemur '+str(self.rawdata[i][48])+' '+str(self.rawdata[i][49])+' '+str(self.rawdata[i][50])+'\n')
      f.write('rtibia '+str(self.rawdata[i][51])+'\n')
      f.write('rfoot '+str(self.rawdata[i][52])+' '+str(self.rawdata[i][53])+'\n')
      f.write('rtoes '+str(self.rawdata[i][54])+'\n')

      f.write('lfemur '+str(self.rawdata[i][55])+' '+str(self.rawdata[i][56])+' '+str(self.rawdata[i][57])+'\n')
      f.write('ltibia '+str(self.rawdata[i][58])+'\n')
      f.write('lfoot '+str(self.rawdata[i][59])+' '+str(self.rawdata[i][60])+'\n')
      f.write('ltoes '+str(self.rawdata[i][61])+'\n')

    f.close()
    print ('wrote amc file '+fname)
