//////////////////////////////////////////////////////////////////////
// 15-462 Computer Graphics I
// Assignment 4: Procedural modeling and animation
//////////////////////////////////////////////////////////////////////
#include <stdlib.h>

#ifdef _WIN32
#include <windows.h>
#endif

#include "lsystem.h"
#include "noise.h"

#include <gfx/gl.h>
#include <GL/glext.h>
#include <GL/glut.h>

#include <gfx/raster.h>
#include <gfx/vec3.h>
#include <gfx/vec2.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#include <stdexcept>

using namespace std;

int g_windowSize[2] = { 640, 480 };
double g_rotate[2] = { 0, 0 };
int g_mousePosition[2] = { 0, 0 };
const GLfloat g_lightpos[4] = { -0.5, 1.0, 1.0, 0.0 };
int g_menuId;
LSystem* g_lsystem;

//////////////////////////////////////////////////////////////////////
// Take a screen shot of the GL context

void screenShot(char* filename) {

  ByteRaster raster(g_windowSize[0], g_windowSize[1], 3);

  glReadPixels(0, 0, g_windowSize[0], g_windowSize[1], 
               GL_RGB, GL_UNSIGNED_BYTE, raster.head() );

  raster.vflip();

  write_image(filename, raster);

}

//////////////////////////////////////////////////////////////////////
// GLUT callback for when window is resized

void reshape(int width, int height) {

  // reset viewport
  glViewport(0, 0, width, height);
  g_windowSize[0] = width;
  g_windowSize[1] = height;

  // now make our projection matrix for our camera

  if (!height) { height = 1; } // prevent divide by zero

  double aspect = (double)width / (double)height;

  const double fov = 45.0; // 45 degree field-of-view
  const double fnear = 0.1; // distance to fnear clipping plane
  const double ffar = 100.0; // distance to far clipping plane

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fov, aspect, fnear, ffar);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  // At this point, the camera is at the origin staring down
  // the negative z axis.

  // let's set up a light in the scene

  glLightfv(GL_LIGHT0, GL_POSITION, g_lightpos);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);

  // want depth buffering
  glEnable(GL_DEPTH_TEST);

  // might come in handy when we scale our height field
  glEnable(GL_RESCALE_NORMAL);

}

//////////////////////////////////////////////////////////////////////
// GLUT callback to draw the window

void display() {

  // clear buffers
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  // draw some primitives in white
  glColor3ub(255, 255, 255);
  
  glMatrixMode(GL_MODELVIEW);
  
  // move the camera back a bit so we can see our primitives
  glPushMatrix();

    glTranslated(0, 0, -7);

    // draw a rotated cube 
    glPushMatrix();
      glRotated(g_rotate[0], 1, 0, 0);
      glRotated(g_rotate[1], 0, 1, 0);
      //drawCube(1.0);
      g_lsystem->renderGL();
    glPopMatrix();

  glPopMatrix();

  // swap buffers
  glutSwapBuffers();

}

//////////////////////////////////////////////////////////////////////
// GLUT idle callback, called whenever GLUT has nothing else to do

void timer(int) {

  // force the window to re-display
  glutPostRedisplay();
  
  glutTimerFunc(50, timer, 0);

}

//////////////////////////////////////////////////////////////////////
// GLUT callback for when the menu is clicked

void menu(int value) {
  // put any menu items here
  switch (value) {
  case 0:
    exit(0);
    break;
  case 1:
    g_lsystem->setMaxDepth(g_lsystem->maxDepth()+1);
    break;
  case 2:
    if (g_lsystem->maxDepth()) {
      g_lsystem->setMaxDepth(g_lsystem->maxDepth()-1);
    }
    break;
  }
  glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// GLUT callback for when the mouse is moved while a button is held

void mouseMotionActive(int x, int y) {

  int mouseDelta[2] = {x - g_mousePosition[0], y - g_mousePosition[1]};

  const float rotationSensitivity = 1.0;

  g_rotate[1] += rotationSensitivity * mouseDelta[0];
  g_rotate[0] += rotationSensitivity * mouseDelta[1];

  g_mousePosition[0] = x;
  g_mousePosition[1] = y;

  glutPostRedisplay();

}

//////////////////////////////////////////////////////////////////////
// GLUT callback for when a mouse button is clicked

void mouseButtonPressed(int button, int state, int x, int y) {

  // update stored mouse position
  g_mousePosition[0] = x;
  g_mousePosition[1] = y;

}

//////////////////////////////////////////////////////////////////////
// GLUT callback for when a keyboard key is pressed

void keyboardKeyPressed(unsigned char key, int x, int y) {

  switch (key) {
  case 'q':
  case 'Q':
    exit(0);
  case ' ':
    screenShot("test.jpg");
    break;
  }

}

//////////////////////////////////////////////////////////////////////
// Parse an lsystem from a file

void parseLSystem(const std::string& filename) {

  char straxiom[256], rule[256];

  std::vector<std::string> rules;

  std::ifstream istr(filename.c_str());
  if (!istr.is_open()) { 
    return;//throw std::runtime_error("couldn't open " + filename);
  }


  istr.getline(straxiom, 256);

//  if (!std::getline(istr, axiom)) {
//    return;//throw std::runtime_error(filename + ":1 missing axiom");
//  }

  while (istr.getline(rule, 256)) {
    rules.push_back(rule);
  }

  g_lsystem = new LSystem(straxiom, rules);

}

//////////////////////////////////////////////////////////////////////
// Main function

int main(int argc, char* argv[]) {

  // make sure command line arguments are correct
  if (argc != 2) {
    //cerr << "Usage : " << argv[0] << " lsystemfile" << endl;
    return 1;
  }

  try {
    parseLSystem(argv[1]);
  } catch (std::runtime_error& e) {
    //std::cerr << "error: " << e.what() << "\n";
    return 1;
  }

  // initialize GLUT
  glutInit(&argc, argv);

  // specify our pixel format, etc
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);

  // specify our window size
  glutInitWindowSize(g_windowSize[0], g_windowSize[1]);

  // give our window a dorky title
  glutCreateWindow("Project 4");

  // create the menu and add a ``quit'' option
  g_menuId = glutCreateMenu(menu);
  glutSetMenu(g_menuId);
  glutAddMenuEntry("Quit", 0);
  glutAddMenuEntry("Increase LSystem depth", 1);
  glutAddMenuEntry("Decrease LSystem depth", 2);
  glutAttachMenu(GLUT_MIDDLE_BUTTON);

  // set a pile of callbacks
  glutReshapeFunc(reshape);
  glutDisplayFunc(display);
  glutTimerFunc(50, timer, 0);
  glutKeyboardFunc(keyboardKeyPressed);
  glutMouseFunc(mouseButtonPressed);
  glutMotionFunc(mouseMotionActive);

  // start the main loop
  glutMainLoop();

  return 0;

}

