#include "lsystem.h"
#include "lsystem_impl.h"


void LSystemRotationNode::render(LSystemRenderContext& c) const {
  // TODO: implement this
}

void LSystemScaleNode::render(LSystemRenderContext& c) const {
  // TODO: implement this
  // hint: don't call glScale -- just modify the current context
}

void LSystemSegmentNode::render(LSystemRenderContext& c) const {

  // TODO: recursive application of rules.
  
  // watch out, could be null:
  const LSystemNode* ruleNode = c.lookup(id);
  
  // If current depth of context is less than max depth and ruleNode
  // was found, should recurse; otherwise, just do this:
  
  glColor3ub(128, 101, 0);
  gluCylinder(c.quadric,
	      c.radiusScale,
	      c.radiusScale * endScaleFraction,
	      c.lengthScale,
	      10, 1);
  glTranslated(0, 0, c.lengthScale);

}

void LSystemLeafNode::render(LSystemRenderContext& context) const {
    // TODO
}


// don't have to do anything here, just included for clarity
void LSystemGroupNode::render(LSystemRenderContext& c) const {
  
  double lengthScale = c.lengthScale;
  double radiusScale = c.radiusScale;
  
  if (restoreState) {
    glPushMatrix();
  }

  for (unsigned int i=0; i<children.size(); ++i) {
    children[i]->render(c);
  }

  if (restoreState) {
    glPopMatrix();
    c.lengthScale = lengthScale;
    c.radiusScale = radiusScale;
  }

}

// don't have to do anything here, just included for clarity
void LSystem::renderGL() const {

  if (!_quadric) {
    _quadric = gluNewQuadric();
  }

  LSystemRenderContext c(_rules, _quadric, _maxDepth);

  glPushMatrix();

  // map the y axis to the z axis so we can use gluCylinder 
  glRotated(-90.0, 1.0, 0.0, 0.0);
  glRotated(90.0, 0.0, 0.0, 1.0);

  _root->render(c);

  glPopMatrix();

}
