// starter.c
//
/////////////////////////////////////////////////////////////////////////////
//
// 15-462
//
// LibPicIO Sample
//
// Author: Greg Reshko
// 
/////////////////////////////////////////////////////////////////////////////
// Copyright 2002 by Greg Reshko.  All rights reserved.
/////////////////////////////////////////////////////////////////////////////


#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <glut.h>
#include <pic.h>

int g_iMenuId;

int g_vMousePos[2] = {0, 0};
// 1 if pressed, 0 if not
int g_iLeftMouseButton = 0;    
int g_iMiddleMouseButton = 0;
int g_iRightMouseButton = 0;

// Control state enum
typedef enum { ROTATE, TRANSLATE, SCALE } CONTROLSTATE;

// Current control state
CONTROLSTATE g_ControlState = ROTATE;

// State of the world
float g_vLandRotate[3] = {0.0, 0.0, 0.0};
float g_vLandTranslate[3] = {0.0, 0.0, 0.0};
float g_vLandScale[3] = {1.0, 1.0, 1.0};

// See /afs/cs/academic/class/15462/include/pic.h for type Pic

// Texture names
static GLuint GroundTextureName;

// Textures
Pic *GroundTexture;

// Initialization
void myinit()
{
  // Set color to black
  glClearColor(0.0, 0.0, 0.0, 0.0);
  // Set smooth shading
  glShadeModel(GL_SMOOTH);

  glEnable(GL_AUTO_NORMAL);
  glEnable(GL_DEPTH_TEST);

  // Set up viewport
  glViewport(0,0,640,480);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45,640.0/480.0,0.1,1000);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(-10.0, -10.0, 10.0, 0.0, 0.0, 0.0, 0.0f,0.0f,1.0f);
  
  // Load textures
  glGenTextures(1, &GroundTextureName);
  glBindTexture(GL_TEXTURE_2D, GroundTextureName);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGB, GL_UNSIGNED_BYTE, GroundTexture->pix);

  // Enable smooth polygons and lines
  glEnable(GL_POLYGON_SMOOTH);
  glEnable(GL_LINE_SMOOTH);
  
}

// Draw ground
void drawGround()
{
  glEnable(GL_TEXTURE_2D);
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
  glBindTexture(GL_TEXTURE_2D, GroundTextureName);
  glColor3f(0.0, 0.0, 1.0);
  glBegin(GL_QUADS);
  glTexCoord2f(0.0, 250.0);  glVertex3f(-100.0, -100.0, 0.0);
  glTexCoord2f(250.0, 250.0); glVertex3f(100.0, -100.0, 0.0);
  glTexCoord2f(250.0, 0.0);  glVertex3f(100.0, 100.0, 0.0);
  glTexCoord2f(0.0, 0.0);   glVertex3f(-100.0, 100.0, 0.0);
  glEnd();
  glDisable(GL_TEXTURE_2D);
}

// Display function
void display()
{
  // Clear buffer
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  // Push new matrix
  glPushMatrix();
	
  // Translation transform
  glTranslatef(g_vLandTranslate[0], g_vLandTranslate[1], g_vLandTranslate[2]);

  // Rotation transform
  glRotatef(g_vLandRotate[0], 1.0, 0.0, 0.0);
  glRotatef(g_vLandRotate[1], 0.0, 1.0, 0.0);
  glRotatef(g_vLandRotate[2], 0.0, 0.0, 1.0);
	
  // Scale transform
  glScalef(g_vLandScale[0], g_vLandScale[1], g_vLandScale[2]);
	
  // Set up texture and draw ground
  drawGround();

  glPopMatrix();

  glutSwapBuffers();
}

// Keyboard callbacks
void processKeys(unsigned char key, int x, int y) 
{
  if (key == 27) 
    exit(0);
}

// Menu callbacks
void menufunc(int value)
{
  switch (value)
    {
    case 0:
      exit(0);
      break;
    }
}

void doIdle()
{
  // Make the screen update
  glutPostRedisplay();
}

// Converts mouse drags into information about 
// rotation/translation/scaling
void mousedrag(int x, int y)
{
  int vMouseDelta[2] = {x-g_vMousePos[0], y-g_vMousePos[1]};
	
  switch (g_ControlState)
    {
    case TRANSLATE:  
      if (g_iLeftMouseButton)
	{
	  g_vLandTranslate[0] += vMouseDelta[0] * 0.1;
	  g_vLandTranslate[1] -= vMouseDelta[1] * 0.1;
	}
      if (g_iMiddleMouseButton)
	{
	  g_vLandTranslate[2] += vMouseDelta[1] * 0.1;
	}
      break;
    case ROTATE:
      if (g_iLeftMouseButton)
	{
	  g_vLandRotate[0] += vMouseDelta[1];
	  g_vLandRotate[1] += vMouseDelta[0];
	}
      if (g_iMiddleMouseButton)
	{
	  g_vLandRotate[2] += vMouseDelta[1];
	}
      break;
    case SCALE:
      if (g_iLeftMouseButton)
	{
	  g_vLandScale[0] *= 1.0+vMouseDelta[0]*0.01;
	  g_vLandScale[1] *= 1.0-vMouseDelta[1]*0.01;
	}
      if (g_iMiddleMouseButton)
	{
	  g_vLandScale[2] *= 1.0-vMouseDelta[1]*0.01;
	}
      break;
    }
  g_vMousePos[0] = x;
  g_vMousePos[1] = y;
}

void mouseidle(int x, int y)
{
  g_vMousePos[0] = x;
  g_vMousePos[1] = y;
}

void mousebutton(int button, int state, int x, int y)
{
	
  switch (button)
    {
    case GLUT_LEFT_BUTTON:
      g_iLeftMouseButton = (state==GLUT_DOWN);
      break;
    case GLUT_MIDDLE_BUTTON:
      g_iMiddleMouseButton = (state==GLUT_DOWN);
      break;
    case GLUT_RIGHT_BUTTON:
      g_iRightMouseButton = (state==GLUT_DOWN);
      break;
    }
	
  switch(glutGetModifiers())
    {
    case GLUT_ACTIVE_CTRL:
      g_ControlState = TRANSLATE;
      break;
    case GLUT_ACTIVE_SHIFT:
      g_ControlState = SCALE;
      break;
    default:
      g_ControlState = ROTATE;
      break;
    }
	
  g_vMousePos[0] = x;
  g_vMousePos[1] = y;
}

int main (int argc, char ** argv)
{
  // Load textures
  GroundTexture = jpeg_read("ground_tex.jpg", NULL);
  
  // Init the GLUT
  glutInit(&argc,argv);
	
  glutInitDisplayMode ( GLUT_DEPTH | GLUT_RGBA | GLUT_DOUBLE );
  glutInitWindowPosition(100,100);  
  glutInitWindowSize  ( 640, 480); 
  glutCreateWindow("15462 Sample");
	
  // Tells glut to use a particular display function to redraw
  glutDisplayFunc(display);
	
  // Allow the user to quit using the right mouse button menu
  g_iMenuId = glutCreateMenu(menufunc);
  glutSetMenu(g_iMenuId);
  glutAddMenuEntry("Quit - Esc",0);
  glutAttachMenu(GLUT_RIGHT_BUTTON);
	
  // Replace with any animate code
  glutIdleFunc(doIdle);
	
  // Callback for mouse drags
  glutMotionFunc(mousedrag);
  // Callback for idle mouse movement
  glutPassiveMotionFunc(mouseidle);
  // Callback for mouse button changes
  glutMouseFunc(mousebutton);
  // Callback for keyboard
  glutKeyboardFunc(processKeys);
	
  // Do initialization
  myinit();
	
  glutMainLoop();

  return(0);
}
