/*
 * Decompiled with CFR 0.152.
 */
package ter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import ter.TERalignment;
import ter.TERcalc;
import ter.TERcost;
import ter.TERpara;
import ter.TERsgml;

public class TERtest {
    private static int tot_ins = 0;
    private static int tot_del = 0;
    private static int tot_sub = 0;
    private static int tot_sft = 0;
    private static int tot_wsf = 0;
    private static float tot_err = 0.0f;
    private static float tot_wds = 0.0f;
    private static String refspan_ext = ".ref";
    private static String hypspan_ext = ".hyp";
    private static boolean has_span = false;

    public static void main(String[] args) {
        int in_ref_format;
        LinkedHashMap refsegs;
        int in_hyp_format;
        LinkedHashMap hypsegs;
        TERpara para = new TERpara();
        HashMap paras = para.getOpts(args);
        String ref_fn = (String)paras.get((Object)TERpara.OPTIONS.REF);
        String hyp_fn = (String)paras.get((Object)TERpara.OPTIONS.HYP);
        Object val = paras.get((Object)TERpara.OPTIONS.NORMALIZE);
        boolean normalized = (Boolean)val;
        val = paras.get((Object)TERpara.OPTIONS.CASEON);
        boolean caseon = (Boolean)val;
        val = paras.get((Object)TERpara.OPTIONS.NOPUNCTUATION);
        boolean nopunct = (Boolean)val;
        val = paras.get((Object)TERpara.OPTIONS.OUTPFX);
        String out_pfx = val != null ? (String)val : "";
        val = paras.get((Object)TERpara.OPTIONS.FORMATS);
        ArrayList formats = new ArrayList();
        if (val != null) {
            formats = (ArrayList)val;
        }
        val = paras.get((Object)TERpara.OPTIONS.BEAMWIDTH);
        int beam_width = (Integer)val;
        val = paras.get((Object)TERpara.OPTIONS.REFLEN);
        String reflen_fn = (String)val;
        val = paras.get((Object)TERpara.OPTIONS.TRANSSPAN);
        String span_pfx = (String)val;
        val = paras.get((Object)TERpara.OPTIONS.SHIFTDIST);
        int shift_dist = (Integer)val;
        TERcost costfunc = new TERcost();
        costfunc._delete_cost = (Double)paras.get((Object)TERpara.OPTIONS.DELETE_COST);
        costfunc._insert_cost = (Double)paras.get((Object)TERpara.OPTIONS.INSERT_COST);
        costfunc._shift_cost = (Double)paras.get((Object)TERpara.OPTIONS.SHIFT_COST);
        costfunc._match_cost = (Double)paras.get((Object)TERpara.OPTIONS.MATCH_COST);
        costfunc._substitute_cost = (Double)paras.get((Object)TERpara.OPTIONS.SUBSTITUTE_COST);
        double TOTAL_EDITS = 0.0;
        double TOTAL_WORDS = 0.0;
        Object reflenstream = null;
        LinkedHashMap reflensegs = null;
        HashMap refsids = null;
        HashMap reflenids = null;
        HashMap refspans = null;
        HashMap hypspans = null;
        TERsgml hypsgm = new TERsgml();
        TERsgml refsgm = new TERsgml();
        TERsgml reflensgm = null;
        Document hypdoc = hypsgm.parse(hyp_fn);
        Document refdoc = refsgm.parse(ref_fn);
        Document reflendoc = null;
        if (hypdoc == null) {
            hypsegs = TERtest.load_segs(hyp_fn);
            System.out.println("\"" + hyp_fn + "\" was successfully parsed as Trans text");
            in_hyp_format = 1;
        } else {
            hypsegs = new LinkedHashMap();
            if (hypdoc == null) {
                System.out.println("hyp doc is null");
            }
            hypsgm.loadSegs(hypdoc, hypsegs);
            in_hyp_format = 2;
        }
        if (refdoc == null) {
            refsegs = TERtest.load_segs(ref_fn);
            System.out.println("\"" + ref_fn + "\" was successfully parsed as Trans text");
            in_ref_format = 1;
        } else {
            refsegs = new LinkedHashMap();
            refsids = new HashMap();
            if (refdoc == null) {
                System.out.println("ref doc is null");
            }
            refsgm.loadSegs(refdoc, refsegs, refsids);
            in_ref_format = 2;
        }
        if (reflen_fn != "") {
            reflensgm = new TERsgml();
            reflendoc = reflensgm.parse(reflen_fn);
            if (reflendoc == null) {
                reflensegs = TERtest.load_segs(reflen_fn);
                System.out.println("\"" + reflen_fn + "\" was successfully parsed as Trans text");
            } else {
                reflensegs = new LinkedHashMap();
                reflenids = new HashMap();
                refsgm.loadSegs(reflendoc, reflensegs, reflenids);
            }
        }
        if (span_pfx != "") {
            has_span = true;
            refspans = TERtest.load_trans_span(String.valueOf(span_pfx) + refspan_ext);
            hypspans = TERtest.load_trans_span(String.valueOf(span_pfx) + hypspan_ext);
        }
        if (!TERtest.verifyFormats(in_ref_format, in_hyp_format, formats)) {
            System.exit(1);
        }
        TERcalc calc = new TERcalc();
        calc.setNormalize(normalized);
        calc.setCase(caseon);
        calc.setPunct(nopunct);
        calc.setBeamWidth(beam_width);
        calc.setShiftDist(shift_dist);
        BufferedWriter xml_out = TERtest.openFile(formats, "xml", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter pra_out = TERtest.openFile(formats, "pra", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter prm_out = TERtest.openFile(formats, "pra_more", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter ter_out = TERtest.openFile(formats, "ter", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter sum_out = TERtest.openFile(formats, "sum", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        BufferedWriter nbt_out = TERtest.openFile(formats, "sum_nbest", out_pfx, hyp_fn, ref_fn, reflen_fn, caseon, hypsgm);
        Pattern id_rank = Pattern.compile("^\\s*(.*):([^ ]*)\\s*$", 2);
        Iterator hypids = hypsegs.keySet().iterator();
        while (hypids.hasNext()) {
            Matcher id_rank_m;
            String id_nrank = "";
            String rank = "";
            String id = (String)hypids.next();
            ArrayList hyps = (ArrayList)hypsegs.get(id);
            String hypspan = "";
            if (has_span) {
                hypspan = (String)hypspans.get(id);
            }
            if ((id_rank_m = id_rank.matcher(id)).matches()) {
                id_nrank = id_rank_m.group(1);
                rank = id_rank_m.group(2);
            } else {
                id_nrank = id;
                id = String.valueOf(id) + ":1";
            }
            if (refsegs.containsKey(id_nrank)) {
                System.out.println("Processing " + id);
                ArrayList refids = refsids != null && refsids.containsKey(id_nrank) ? (ArrayList)refsids.get(id_nrank) : new ArrayList(1);
                ArrayList reflenseglist = null;
                if (reflensegs != null && (reflenseglist = (ArrayList)reflensegs.get(id_nrank)) == null) {
                    System.out.println("Warning: NO reference length can be found for hyp: " + refids);
                }
                String refspan = "";
                if (has_span) {
                    refspan = (String)refspans.get(id_nrank);
                }
                TERalignment result = TERtest.score_all_refs((String)hyps.get(0), (ArrayList)refsegs.get(id_nrank), reflenseglist, refids, refspan, hypspan, costfunc, calc);
                TOTAL_EDITS += result.numEdits;
                TOTAL_WORDS += result.numWords;
                try {
                    if (ter_out != null) {
                        ter_out.write(String.valueOf(id) + " " + result.numEdits + " " + result.numWords + " " + result.score() + "\n");
                    }
                    if (xml_out != null) {
                        hypsgm.writeXMLAlignment(xml_out, result, id, in_ref_format == 1);
                    }
                    if (pra_out != null) {
                        pra_out.write("Sentence ID: " + id + "\n" + result.toString() + "\n\n");
                    }
                    if (prm_out != null) {
                        prm_out.write("Sentence ID: " + id + "\n" + result.toMoreString() + "\n\n");
                    }
                    if (sum_out != null) {
                        TERtest.writeSummary(sum_out, result, id);
                    }
                    if (nbt_out == null) continue;
                    TERtest.writeNbestSum(nbt_out, result, id);
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    return;
                }
            }
            System.out.println("***ERROR*** No reference for segment " + id_nrank);
            System.exit(1);
        }
        TERtest.closeFile(xml_out, "xml", hypsgm);
        TERtest.closeFile(pra_out, "pra", hypsgm);
        TERtest.closeFile(prm_out, "pra_more", hypsgm);
        TERtest.closeFile(ter_out, "ter", hypsgm);
        TERtest.closeFile(sum_out, "sum", hypsgm);
        TERtest.closeFile(nbt_out, "sum_nbest", hypsgm);
        System.out.println("Total TER: " + TOTAL_EDITS / TOTAL_WORDS + " (" + TOTAL_EDITS + "/" + TOTAL_WORDS + ")");
        System.out.println("Number of calls to beam search: " + calc.numBeamCalls());
        System.out.println("Number of segments scored: " + calc.numSegsScored());
        System.out.println("Number of shifts tried: " + calc.numShiftsTried());
    }

    public static BufferedWriter openFile(ArrayList formats, String type, String out_pfx, String hyp_fn, String ref_fn, String reflen_fn, boolean caseon, TERsgml sgml) {
        BufferedWriter bw = null;
        if (out_pfx != "" && formats != null && formats.contains(type)) {
            try {
                bw = new BufferedWriter(new FileWriter(String.valueOf(out_pfx) + "." + type));
                if (type.equals("xml")) {
                    sgml.writeXMLHeader(bw, hyp_fn, ref_fn, caseon);
                } else if (type.equals("sum")) {
                    bw.write("Hypothesis File: " + hyp_fn + "\nReference File: " + ref_fn + "\n" + "Ave-Reference File: " + (reflen_fn == "" ? ref_fn : reflen_fn) + "\n");
                    bw.write(String.format("%1$-19s | %2$-4s | %3$-4s | %4$-4s | %5$-4s | %6$-4s | %7$-6s | %8$-8s | %9$-8s\n", "Sent Id", "Ins", "Del", "Sub", "Shft", "WdSh", "NumEr", "NumWd", "TER"));
                    bw.write("-------------------------------------------------------------------------------------\n");
                } else if (type.equals("ter")) {
                    bw.write("Hypothesis File: " + hyp_fn + "\nReference File: " + ref_fn + "\n");
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
        return bw;
    }

    public static void closeFile(BufferedWriter bw, String type, TERsgml sgml) {
        if (bw != null) {
            try {
                if (type.equals("xml")) {
                    sgml.writeXMLFooter(bw);
                } else if (type.equals("sum")) {
                    bw.write("-------------------------------------------------------------------------------------\n");
                    bw.write(String.format("%1$-19s | %2$-4d | %3$-4d | %4$-4d | %5$-4d | %6$-4d | %7$-6.1f | %8$-8.3f | %9$-8.3f\n", "TOTAL", tot_ins, tot_del, tot_sub, tot_sft, tot_wsf, Float.valueOf(tot_err), Float.valueOf(tot_wds), (double)tot_err * 100.0 / (double)tot_wds));
                }
                bw.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                return;
            }
        }
    }

    public static void writeSummary(BufferedWriter sum, TERalignment result, String id) {
        try {
            result.scoreDetails();
            sum.write(String.format("%1$-19s | %2$4d | %3$4d | %4$4d | %5$4d | %6$4d | %7$6.1f | %8$8.3f | %9$8.3f\n", id, result.numIns, result.numDel, result.numSub, result.numSft, result.numWsf, result.numEdits, result.numWords, result.score() * 100.0));
            tot_ins += result.numIns;
            tot_del += result.numDel;
            tot_sub += result.numSub;
            tot_sft += result.numSft;
            tot_wsf += result.numWsf;
            tot_err = (float)((double)tot_err + result.numEdits);
            tot_wds = (float)((double)tot_wds + result.numWords);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public static void writeNbestSum(BufferedWriter nbt, TERalignment result, String id) {
        try {
            result.scoreDetails();
            nbt.write(String.format("%1$-19s %2$4d %3$4d %4$4d %5$4d %6$4d %7$6.1f %8$8.3f %9$8.3f\n", id, result.numIns, result.numDel, result.numSub, result.numSft, result.numWsf, result.numEdits, result.numWords, result.score() * 100.0));
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public static boolean verifyFormats(int in_ref_format, int in_hyp_format, ArrayList out_formats) {
        if (in_ref_format != in_hyp_format) {
            System.out.println("** Error: Both hypothesis and reference have to be in the SAME format");
            return false;
        }
        if (in_ref_format == 1 && out_formats.indexOf("xml") > -1) {
            System.out.println("** Warning: XML ouput may not have correct doc id for Trans format inputs");
            return true;
        }
        return true;
    }

    public static TERalignment score_all_refs(String hyp, List refs, List reflens, List refids, String refspan, String hypspan, TERcost costfunc, TERcalc calc) {
        double totwords = 0.0;
        String refid = "";
        String bestref = "";
        String reflen = "";
        TERalignment bestresult = null;
        if (has_span && refs.size() > 1) {
            System.out.println("Error, translation spans should only be used with SINGLE reference");
            System.exit(1);
        }
        calc.setRefLen(reflens);
        int i = 0;
        while (i < refs.size()) {
            String ref = (String)refs.get(i);
            if (!refids.isEmpty()) {
                refid = (String)refids.get(i);
            }
            if (has_span) {
                calc.setRefSpan(refspan);
                calc.setHypSpan(hypspan);
            }
            TERalignment result = calc.TER(hyp, ref, costfunc);
            if (bestresult == null || bestresult.numEdits > result.numEdits) {
                bestresult = result;
                if (!refids.isEmpty()) {
                    bestref = refid;
                }
            }
            totwords += result.numWords;
            ++i;
        }
        bestresult.numWords = totwords / (double)refs.size();
        if (!refids.isEmpty()) {
            bestresult.bestRef = bestref;
        }
        return bestresult;
    }

    /*
     * Unable to fully structure code
     */
    public static LinkedHashMap load_segs(String fn) {
        p = Pattern.compile("^\\s*(.*?)\\s*\\(([^()]+)\\)\\s*$");
        segs = new LinkedHashMap<String, ArrayList<String>>();
        try {
            stream = new BufferedReader(new FileReader(fn));
            if (true) ** GOTO lbl26
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
        {
            do {
                if (line.matches("^\\s*$")) continue;
                m = p.matcher(line);
                if (m.matches()) {
                    text = m.group(1);
                    id = m.group(2);
                    val = segs.get(id);
                    if (val == null) {
                        al = new ArrayList<String>(6);
                        segs.put(id, al);
                    } else {
                        al = (ArrayList<String>)val;
                    }
                    al.add(text.trim());
                    continue;
                }
                System.out.println("Warning, Invalid line: " + line);
lbl26:
                // 4 sources

            } while ((line = stream.readLine()) != null);
        }
        return segs;
    }

    private static HashMap load_trans_span(String fn) {
        Pattern p = Pattern.compile("^\\s*(.*?)\\s*\\(([^()]+)\\)\\s*$");
        HashMap<String, String> spans = new HashMap<String, String>();
        try {
            String line;
            BufferedReader stream = new BufferedReader(new FileReader(fn));
            while ((line = stream.readLine()) != null) {
                if (line.matches("^\\s*$")) continue;
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    String text = m.group(1);
                    String id = m.group(2);
                    Object val = spans.get(id);
                    if (val == null) {
                        spans.put(id, text);
                        continue;
                    }
                    System.out.println("Error, translation spans should only be used with SINGLE reference");
                    System.exit(1);
                    continue;
                }
                System.out.println("Warning, Invalid line: " + line);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
        return spans;
    }
}

