/*
 * Decompiled with CFR 0.152.
 */
package ter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TERpara {
    private String reffn = "";
    private String hypfn = "";
    private String reflenfn = "";
    private boolean mt_normalized = false;
    private boolean case_on = false;
    private boolean no_punctuation = false;
    private ArrayList out_formats;
    private String out_pfx = "";
    private Pattern opts_p = Pattern.compile("^\\s*-(\\S+)\\s*$");
    private int beam_width = 20;
    private String span_pfx = "";
    private int shift_dist = 50;
    private double shift_cost = 1.0;
    private double delete_cost = 1.0;
    private double insert_cost = 1.0;
    private double substitute_cost = 1.0;
    private double match_cost = 0.0;

    public HashMap getOpts(String[] args) {
        HashMap<OPTIONS, Object> paras = new HashMap<OPTIONS, Object>();
        int i = 0;
        while (i < args.length) {
            Matcher m = this.opts_p.matcher(args[i]);
            if (m.matches()) {
                char opt = m.group(1).charAt(0);
                switch (opt) {
                    case 'N': {
                        this.mt_normalized = true;
                        break;
                    }
                    case 's': {
                        this.case_on = true;
                        break;
                    }
                    case 'P': {
                        this.no_punctuation = true;
                        break;
                    }
                    case 'r': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.reffn = args[++i];
                        break;
                    }
                    case 'h': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.hypfn = args[++i];
                        break;
                    }
                    case 'o': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.out_formats = TERpara.getOutFormats(args[++i]);
                        break;
                    }
                    case 'n': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.out_pfx = args[++i];
                        break;
                    }
                    case 'b': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.beam_width = Integer.valueOf(args[++i]);
                        break;
                    }
                    case 'a': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.reflenfn = args[++i];
                        break;
                    }
                    case 'S': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.span_pfx = args[++i];
                        break;
                    }
                    case 'd': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.shift_dist = Integer.valueOf(args[++i]);
                        break;
                    }
                    case 'M': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.match_cost = Double.valueOf(args[++i]);
                        break;
                    }
                    case 'T': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.shift_cost = Double.valueOf(args[++i]);
                        break;
                    }
                    case 'I': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.insert_cost = Double.valueOf(args[++i]);
                        break;
                    }
                    case 'D': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.delete_cost = Double.valueOf(args[++i]);
                        break;
                    }
                    case 'B': {
                        if (i == args.length - 1 || args[i + 1].charAt(0) == '-') {
                            TERpara.usage();
                            break;
                        }
                        this.substitute_cost = Double.valueOf(args[++i]);
                    }
                }
            } else {
                TERpara.usage();
            }
            ++i;
        }
        if (this.reffn.equals("") || this.hypfn.equals("")) {
            System.out.println("** Please specify both reference and hypothesis inputs");
            TERpara.usage();
        } else {
            if (this.out_formats == null || this.out_formats.isEmpty()) {
                this.out_formats = TERpara.getOutFormats("sum,pra,pra_more,xml,ter,sum_nbest");
            }
            paras.put(OPTIONS.NORMALIZE, this.mt_normalized);
            paras.put(OPTIONS.CASEON, this.case_on);
            paras.put(OPTIONS.NOPUNCTUATION, this.no_punctuation);
            paras.put(OPTIONS.OUTPFX, this.out_pfx);
            paras.put(OPTIONS.REF, this.reffn);
            paras.put(OPTIONS.HYP, this.hypfn);
            paras.put(OPTIONS.FORMATS, this.out_formats);
            paras.put(OPTIONS.BEAMWIDTH, this.beam_width);
            paras.put(OPTIONS.REFLEN, this.reflenfn);
            paras.put(OPTIONS.TRANSSPAN, this.span_pfx);
            paras.put(OPTIONS.SHIFTDIST, this.shift_dist);
            paras.put(OPTIONS.SHIFT_COST, this.shift_cost);
            paras.put(OPTIONS.MATCH_COST, this.match_cost);
            paras.put(OPTIONS.INSERT_COST, this.insert_cost);
            paras.put(OPTIONS.DELETE_COST, this.delete_cost);
            paras.put(OPTIONS.SUBSTITUTE_COST, this.substitute_cost);
        }
        return paras;
    }

    public static void usage() {
        System.out.println("** Usage: java -jar tercom.jar [-N] [-s] [-P] -r ref -h hyp [-a alter_ref] [-b beam_width] [-S trans_span_prefix] [-o out_format -n out_pefix] [-d max_shift_distance] [-M match_cost] [-D delete_cost] [-B substitute_cost] [-I insert_cost] [-T shift_cost]");
        System.exit(1);
    }

    private static ArrayList getOutFormats(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] arrays = s.split(",");
        if (arrays != null) {
            int i = 0;
            while (i < arrays.length) {
                ret.add(arrays[i]);
                ++i;
            }
        }
        return ret;
    }

    public static enum OPTIONS {
        NORMALIZE,
        CASEON,
        NOPUNCTUATION,
        REF,
        HYP,
        FORMATS,
        OUTPFX,
        BEAMWIDTH,
        REFLEN,
        TRANSSPAN,
        SHIFTDIST,
        DELETE_COST,
        INSERT_COST,
        SUBSTITUTE_COST,
        MATCH_COST,
        SHIFT_COST;

    }
}

