/*
 * Decompiled with CFR 0.152.
 */
package ter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ter.TERalignment;
import ter.TERcost;
import ter.TERintpair;
import ter.TERshift;

public class TERcalc {
    private static final boolean DEBUG = false;
    private boolean normalized = false;
    private boolean caseon = false;
    private boolean nopunct = false;
    private TERintpair[] refSpans = null;
    private TERintpair[] hypSpans = null;
    public double ref_len = -1.0;
    public int BEAM_WIDTH = 20;
    private static final double INF = 999999.0;
    private final int MAX_SHIFT_SIZE = 10;
    private int MAX_SHIFT_DIST = 50;
    private int NUM_SEGMENTS_SCORED = 0;
    private int NUM_SHIFTS_CONSIDERED = 0;
    private int NUM_BEAM_SEARCH_CALLS = 0;
    private double[][] S = new double[350][350];
    private char[][] P = new char[350][350];

    public void setNormalize(boolean b) {
        this.normalized = b;
    }

    public void setCase(boolean b) {
        this.caseon = b;
    }

    public void setPunct(boolean b) {
        this.nopunct = b;
    }

    public void setBeamWidth(int i) {
        this.BEAM_WIDTH = i;
    }

    public void setShiftDist(int i) {
        this.MAX_SHIFT_DIST = i;
    }

    public void setRefSpan(String span) {
        if (span != null && span.trim() != "") {
            String[] spans = span.split("\\s+");
            this.refSpans = new TERintpair[spans.length];
            int i = 0;
            while (i < spans.length) {
                String[] s = spans[i].split(":");
                this.refSpans[i] = new TERintpair(Integer.valueOf(s[0]), Integer.valueOf(s[1]));
                ++i;
            }
        }
    }

    public void setHypSpan(String span) {
        if (span != null && span.trim() != "") {
            String[] spans = span.split("\\s+");
            this.hypSpans = new TERintpair[spans.length];
            int i = 0;
            while (i < spans.length) {
                String[] s = spans[i].split(":");
                this.hypSpans[i] = new TERintpair(Integer.valueOf(s[0]), Integer.valueOf(s[1]));
                ++i;
            }
        }
    }

    public void setRefLen(List reflens) {
        String reflen = "";
        if (reflens == null || reflens.size() == 0) {
            this.ref_len = -1.0;
            return;
        }
        this.ref_len = 0.0;
        int i = 0;
        while (i < reflens.size()) {
            reflen = (String)reflens.get(i);
            this.ref_len = reflen.length() == 0 ? (this.ref_len += 0.0) : (this.ref_len += (double)this.tokenize(reflen).length);
            ++i;
        }
        this.ref_len /= (double)reflens.size();
    }

    public void setRefLen(double d) {
        this.ref_len = d >= 0.0 ? d : -1.0;
    }

    public TERalignment TER(Comparable[] hyp, Comparable[] ref) {
        return this.TER(hyp, ref, new TERcost());
    }

    public TERalignment TER(String hyp, String ref) {
        return this.TER(hyp, ref, new TERcost());
    }

    public TERalignment TER(String hyp, String ref, TERcost costfunc) {
        TERalignment to_return;
        if (!this.caseon) {
            hyp = hyp.toLowerCase();
            ref = ref.toLowerCase();
        }
        if (ref.length() == 0 || hyp.length() == 0) {
            to_return = this.TERnullstr(hyp, ref, costfunc);
            if (this.ref_len >= 0.0) {
                to_return.numWords = this.ref_len;
            }
        } else {
            String[] hyparr = this.tokenize(hyp);
            String[] refarr = this.tokenize(ref);
            to_return = this.TER((Comparable[])hyparr, (Comparable[])refarr, costfunc);
            if (this.ref_len >= 0.0) {
                to_return.numWords = this.ref_len;
            }
        }
        return to_return;
    }

    public TERalignment TERnullstr(String hyp, String ref, TERcost costfunc) {
        TERalignment to_return = new TERalignment();
        String[] hyparr = this.tokenize(hyp);
        String[] refarr = this.tokenize(ref);
        if (hyp.length() == 0 && ref.length() == 0) {
            to_return.numWords = 0.0;
            to_return.numEdits = 0.0;
        } else if (hyp.length() == 0) {
            to_return.alignment = new char[refarr.length];
            int i = 0;
            while (i < refarr.length) {
                to_return.alignment[i] = 68;
                ++i;
            }
            to_return.numWords = refarr.length;
            to_return.numEdits = refarr.length;
        } else {
            to_return.alignment = new char[hyparr.length];
            int i = 0;
            while (i < hyparr.length) {
                to_return.alignment[i] = 73;
                ++i;
            }
            to_return.numWords = 0.0;
            to_return.numEdits = hyparr.length;
        }
        to_return.hyp = hyparr;
        to_return.ref = refarr;
        to_return.aftershift = hyparr;
        return to_return;
    }

    public TERalignment TER(Comparable[] hyp, Comparable[] ref, TERcost costfunc) {
        Object[] returns;
        Map rloc = this.BuildWordMatches(hyp, ref);
        TERalignment cur_align = this.MinEditDist(hyp, ref, costfunc, this.hypSpans);
        Comparable[] cur = hyp;
        cur_align.hyp = hyp;
        cur_align.ref = ref;
        cur_align.aftershift = hyp;
        double edits = 0.0;
        boolean numshifts = false;
        ArrayList<TERshift> allshifts = new ArrayList<TERshift>(hyp.length + ref.length);
        while ((returns = this.CalcBestShift(cur, hyp, ref, rloc, cur_align, costfunc)) != null) {
            TERshift bestShift = (TERshift)returns[0];
            edits += bestShift.cost;
            cur_align = (TERalignment)returns[1];
            bestShift.alignment = cur_align.alignment;
            bestShift.aftershift = cur_align.aftershift;
            allshifts.add(bestShift);
            cur = cur_align.aftershift;
        }
        TERalignment to_return = cur_align;
        to_return.allshifts = allshifts.toArray(new TERshift[0]);
        to_return.numEdits += edits;
        ++this.NUM_SEGMENTS_SCORED;
        return to_return;
    }

    public String[] tokenize(String s) {
        if (this.normalized) {
            s = s.replaceAll("<skipped>", "");
            s = s.replaceAll("-\n", "");
            s = s.replaceAll("\n", " ");
            s = s.replaceAll("&quot;", "\"");
            s = s.replaceAll("&amp;", "&");
            s = s.replaceAll("&lt;", "<");
            s = s.replaceAll("&gt;", ">");
            s = " " + s + " ";
            s = s.replaceAll("([\\{-\\~\\[-\\` -\\&\\(-\\+\\:-\\@\\/])", " $1 ");
            s = s.replaceAll("'s ", " 's ");
            s = s.replaceAll("'s$", " 's");
            s = s.replaceAll("([^0-9])([\\.,])", "$1 $2 ");
            s = s.replaceAll("([\\.,])([^0-9])", " $1 $2");
            s = s.replaceAll("([0-9])(-)", "$1 $2 ");
            s = s.replaceAll("\\s+", " ");
            s = s.replaceAll("^\\s+", "");
            s = s.replaceAll("\\s+$", "");
        }
        if (this.nopunct) {
            s = TERcalc.removePunctuation(s);
        }
        return s.split("\\s+");
    }

    private static String removePunctuation(String str) {
        String s = str.replaceAll("[\\.,\\?:;!\"\\(\\)]", "");
        s = s.replaceAll("\\s+", " ");
        return s;
    }

    private Map BuildWordMatches(Comparable[] hyp, Comparable[] ref) {
        HashSet<Comparable> hwhash = new HashSet<Comparable>();
        int i = 0;
        while (i < hyp.length) {
            hwhash.add(hyp[i]);
            ++i;
        }
        boolean[] cor = new boolean[ref.length];
        int i2 = 0;
        while (i2 < ref.length) {
            cor[i2] = hwhash.contains(ref[i2]);
            ++i2;
        }
        List<Comparable> reflist = Arrays.asList(ref);
        HashMap to_return = new HashMap();
        int start = 0;
        while (start < ref.length) {
            if (cor[start]) {
                int end = start;
                while (end < ref.length && end - start <= 10 && cor[end]) {
                    Set<Integer> vals;
                    List<Comparable> topush = reflist.subList(start, end + 1);
                    if (to_return.containsKey(topush)) {
                        vals = (Set)to_return.get(topush);
                        vals.add(new Integer(start));
                    } else {
                        vals = new TreeSet();
                        vals.add(new Integer(start));
                        to_return.put(topush, vals);
                    }
                    ++end;
                }
            }
            ++start;
        }
        return to_return;
    }

    private static void FindAlignErr(TERalignment align, boolean[] herr, boolean[] rerr, int[] ralign) {
        int hpos = -1;
        int rpos = -1;
        int i = 0;
        while (i < align.alignment.length) {
            char sym = align.alignment[i];
            if (sym == ' ') {
                herr[++hpos] = false;
                rerr[++rpos] = false;
                ralign[rpos] = hpos;
            } else if (sym == 'S') {
                herr[++hpos] = true;
                rerr[++rpos] = true;
                ralign[rpos] = hpos;
            } else if (sym == 'I') {
                herr[++hpos] = true;
            } else if (sym == 'D') {
                rerr[++rpos] = true;
                ralign[rpos] = hpos;
            } else {
                System.err.print("Error!  Invalid mini align sequence " + sym + " at pos " + i + "\n");
                System.exit(-1);
            }
            ++i;
        }
    }

    private Object[] CalcBestShift(Comparable[] cur, Comparable[] hyp, Comparable[] ref, Map rloc, TERalignment med_align, TERcost costfunc) {
        Object[] to_return = new Object[2];
        boolean anygain = false;
        boolean[] herr = new boolean[hyp.length];
        boolean[] rerr = new boolean[ref.length];
        int[] ralign = new int[ref.length];
        TERcalc.FindAlignErr(med_align, herr, rerr, ralign);
        TERshift[][] poss_shifts = this.GatherAllPossShifts(cur, ref, rloc, med_align, herr, rerr, ralign, costfunc);
        double curerr = med_align.numEdits;
        double cur_best_shift_cost = 0.0;
        TERalignment cur_best_align = med_align;
        TERshift cur_best_shift = new TERshift();
        int i = poss_shifts.length - 1;
        while (i >= 0) {
            double curfix = curerr - (cur_best_shift_cost + cur_best_align.numEdits);
            double maxfix = 2 * (1 + i);
            if (curfix > maxfix || cur_best_shift_cost != 0.0 && curfix == maxfix) break;
            int s = 0;
            while (s < poss_shifts[i].length) {
                curfix = curerr - (cur_best_shift_cost + cur_best_align.numEdits);
                if (curfix > maxfix || cur_best_shift_cost != 0.0 && curfix == maxfix) break;
                TERshift curshift = poss_shifts[i][s];
                Object[] shiftReturns = this.PerformShift(cur, curshift);
                Comparable[] shiftarr = (Comparable[])shiftReturns[0];
                TERintpair[] curHypSpans = (TERintpair[])shiftReturns[1];
                TERalignment curalign = this.MinEditDist(shiftarr, ref, costfunc, curHypSpans);
                curalign.hyp = hyp;
                curalign.ref = ref;
                curalign.aftershift = shiftarr;
                double gain = cur_best_align.numEdits + cur_best_shift_cost - (curalign.numEdits + curshift.cost);
                if (gain > 0.0 || cur_best_shift_cost == 0.0 && gain == 0.0) {
                    anygain = true;
                    cur_best_shift = curshift;
                    cur_best_shift_cost = curshift.cost;
                    cur_best_align = curalign;
                }
                ++s;
            }
            --i;
        }
        if (anygain) {
            to_return[0] = cur_best_shift;
            to_return[1] = cur_best_align;
            return to_return;
        }
        return null;
    }

    private TERshift[][] GatherAllPossShifts(Comparable[] hyp, Comparable[] ref, Map rloc, TERalignment align, boolean[] herr, boolean[] rerr, int[] ralign, TERcost costfunc) {
        if (this.MAX_SHIFT_DIST <= 0) {
            TERshift[][] to_return = new TERshift[][]{};
            return to_return;
        }
        ArrayList[] allshifts = new ArrayList[11];
        int i = 0;
        while (i < allshifts.length) {
            allshifts[i] = new ArrayList();
            ++i;
        }
        List<Comparable> hyplist = Arrays.asList(hyp);
        int start = 0;
        while (start < hyp.length) {
            if (rloc.containsKey(hyplist.subList(start, start + 1))) {
                boolean ok = false;
                Iterator mti = ((Set)rloc.get(hyplist.subList(start, start + 1))).iterator();
                while (mti.hasNext() && !ok) {
                    int moveto = (Integer)mti.next();
                    if (start == ralign[moveto] || ralign[moveto] - start > this.MAX_SHIFT_DIST || start - ralign[moveto] - 1 > this.MAX_SHIFT_DIST) continue;
                    ok = true;
                }
                if (ok) {
                    ok = true;
                    int end = start;
                    while (ok && end < hyp.length && end < start + 10) {
                        List<Comparable> cand = hyplist.subList(start, end + 1);
                        ok = false;
                        if (rloc.containsKey(cand)) {
                            boolean any_herr = false;
                            int i2 = 0;
                            while (i2 <= end - start && !any_herr) {
                                if (herr[start + i2]) {
                                    any_herr = true;
                                }
                                ++i2;
                            }
                            if (!any_herr) {
                                ok = true;
                            } else {
                                Iterator movetoit = ((Set)rloc.get(cand)).iterator();
                                while (movetoit.hasNext()) {
                                    int moveto = (Integer)movetoit.next();
                                    if (ralign[moveto] == start || ralign[moveto] >= start && ralign[moveto] <= end || ralign[moveto] - start > this.MAX_SHIFT_DIST || start - ralign[moveto] > this.MAX_SHIFT_DIST) continue;
                                    ok = true;
                                    boolean any_rerr = false;
                                    int i3 = 0;
                                    while (i3 <= end - start && !any_rerr) {
                                        if (rerr[moveto + i3]) {
                                            any_rerr = true;
                                        }
                                        ++i3;
                                    }
                                    if (!any_rerr) continue;
                                    int roff = -1;
                                    while (roff <= end - start) {
                                        TERshift topush = null;
                                        if (roff == -1 && moveto == 0) {
                                            topush = new TERshift(start, end, -1, -1);
                                        } else if (start != ralign[moveto + roff] && (roff == 0 || ralign[moveto + roff] != ralign[moveto])) {
                                            int newloc = ralign[moveto + roff];
                                            topush = new TERshift(start, end, moveto + roff, newloc);
                                        }
                                        if (topush != null) {
                                            topush.shifted = cand;
                                            topush.cost = costfunc.shift_cost(topush);
                                            allshifts[end - start].add(topush);
                                        }
                                        ++roff;
                                    }
                                }
                            }
                        }
                        ++end;
                    }
                }
            }
            ++start;
        }
        TERshift[][] to_return = new TERshift[11][];
        int i4 = 0;
        while (i4 < to_return.length) {
            to_return[i4] = allshifts[i4].toArray(new TERshift[0]);
            ++i4;
        }
        return to_return;
    }

    public Object[] PerformShift(Comparable[] words, TERshift s) {
        return this.PerformShift(words, s.start, s.end, s.newloc);
    }

    private Object[] PerformShift(Comparable[] words, int start, int end, int newloc) {
        int c = 0;
        Comparable[] nwords = (Comparable[])words.clone();
        TERintpair[] spans = null;
        Object[] toreturn = new Object[2];
        if (this.hypSpans != null) {
            spans = new TERintpair[this.hypSpans.length];
        }
        if (newloc == -1) {
            int i = start;
            while (i <= end) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = 0;
            while (i <= start - 1) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = end + 1;
            while (i < words.length) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
        } else if (newloc < start) {
            int i = 0;
            while (i <= newloc) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = start;
            while (i <= end) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = newloc + 1;
            while (i <= start - 1) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = end + 1;
            while (i < words.length) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
        } else if (newloc > end) {
            int i = 0;
            while (i <= start - 1) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = end + 1;
            while (i <= newloc) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = start;
            while (i <= end) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = newloc + 1;
            while (i < words.length) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i <= start - 1) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = end + 1;
            while (i < words.length && i <= end + (newloc - start)) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = start;
            while (i <= end) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
            i = end + (newloc - start) + 1;
            while (i < words.length) {
                nwords[c++] = words[i];
                if (this.hypSpans != null) {
                    spans[c - 1] = this.hypSpans[i];
                }
                ++i;
            }
        }
        ++this.NUM_SHIFTS_CONSIDERED;
        toreturn[0] = nwords;
        toreturn[1] = spans;
        return toreturn;
    }

    private TERalignment MinEditDist(Comparable[] hyp, Comparable[] ref, TERcost costfunc, TERintpair[] curHypSpans) {
        int j;
        double current_best = 999999.0;
        double last_best = 999999.0;
        int first_good = 0;
        int current_first_good = 0;
        int last_good = -1;
        int cur_last_good = 0;
        int last_peak = 0;
        int cur_last_peak = 0;
        int hwsize = hyp.length - 1;
        int rwsize = ref.length - 1;
        ++this.NUM_BEAM_SEARCH_CALLS;
        if (ref.length + 1 > this.S.length || hyp.length + 1 > this.S.length) {
            int max = ref.length;
            if (hyp.length > ref.length) {
                max = hyp.length;
            }
            this.S = new double[max += 26][max];
            this.P = new char[max][max];
        }
        int i = 0;
        while (i <= ref.length) {
            j = 0;
            while (j <= hyp.length) {
                this.S[i][j] = -1.0;
                this.P[i][j] = 48;
                ++j;
            }
            ++i;
        }
        this.S[0][0] = 0.0;
        j = 0;
        while (j <= hyp.length) {
            last_best = current_best;
            current_best = 999999.0;
            first_good = current_first_good;
            current_first_good = -1;
            last_good = cur_last_good;
            cur_last_good = -1;
            last_peak = cur_last_peak;
            cur_last_peak = 0;
            i = first_good;
            while (i <= ref.length) {
                if (i > last_good) break;
                if (!(this.S[i][j] < 0.0)) {
                    double score = this.S[i][j];
                    if (j >= hyp.length || !(score > last_best + (double)this.BEAM_WIDTH)) {
                        if (current_first_good == -1) {
                            current_first_good = i;
                        }
                        if (i < ref.length && j < hyp.length && (this.refSpans == null || this.hypSpans == null || TERcalc.spanIntersection(this.refSpans[i], curHypSpans[j]))) {
                            double cost;
                            if (ref[i].equals(hyp[j])) {
                                cost = costfunc.match_cost(hyp[j], ref[i]) + score;
                                if (this.S[i + 1][j + 1] == -1.0 || cost < this.S[i + 1][j + 1]) {
                                    this.S[i + 1][j + 1] = cost;
                                    this.P[i + 1][j + 1] = 32;
                                }
                                if (cost < current_best) {
                                    current_best = cost;
                                }
                                if (current_best == cost) {
                                    cur_last_peak = i + 1;
                                }
                            } else {
                                cost = costfunc.substitute_cost(hyp[j], ref[i]) + score;
                                if (this.S[i + 1][j + 1] < 0.0 || cost < this.S[i + 1][j + 1]) {
                                    this.S[i + 1][j + 1] = cost;
                                    this.P[i + 1][j + 1] = 83;
                                    if (cost < current_best) {
                                        current_best = cost;
                                    }
                                    if (current_best == cost) {
                                        cur_last_peak = i + 1;
                                    }
                                }
                            }
                        }
                        cur_last_good = i + 1;
                        if (j < hyp.length) {
                            double icost = score + costfunc.insert_cost(hyp[j]);
                            if (this.S[i][j + 1] < 0.0 || this.S[i][j + 1] > icost) {
                                this.S[i][j + 1] = icost;
                                this.P[i][j + 1] = 73;
                                if (cur_last_peak < i && current_best == icost) {
                                    cur_last_peak = i;
                                }
                            }
                        }
                        if (i < ref.length) {
                            double dcost = score + costfunc.delete_cost(ref[i]);
                            if (this.S[i + 1][j] < 0.0 || this.S[i + 1][j] > dcost) {
                                this.S[i + 1][j] = dcost;
                                this.P[i + 1][j] = 68;
                                if (i >= last_good) {
                                    last_good = i + 1;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        int tracelength = 0;
        i = ref.length;
        j = hyp.length;
        while (i > 0 || j > 0) {
            ++tracelength;
            if (this.P[i][j] == ' ') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'S') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'D') {
                --i;
                continue;
            }
            if (this.P[i][j] == 'I') {
                --j;
                continue;
            }
            System.out.println("Invalid path: " + this.P[i][j]);
            System.exit(-1);
        }
        char[] path = new char[tracelength];
        i = ref.length;
        j = hyp.length;
        while (i > 0 || j > 0) {
            path[--tracelength] = this.P[i][j];
            if (this.P[i][j] == ' ') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'S') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'D') {
                --i;
                continue;
            }
            if (this.P[i][j] != 'I') continue;
            --j;
        }
        TERalignment to_return = new TERalignment();
        to_return.numWords = ref.length;
        to_return.alignment = path;
        to_return.numEdits = this.S[ref.length][hyp.length];
        return to_return;
    }

    private static boolean spanIntersection(String refSpan, String hypSpan) {
        String[] hSpans = hypSpan.split(":");
        String[] rSpans = refSpan.split(":");
        return Integer.valueOf(rSpans[1]) >= Integer.valueOf(hSpans[0]) && Integer.valueOf(rSpans[0]) <= Integer.valueOf(hSpans[1]);
    }

    private static boolean spanIntersection(TERintpair refSpan, TERintpair hypSpan) {
        return refSpan.cdr >= hypSpan.car && refSpan.car <= hypSpan.cdr;
    }

    public int numBeamCalls() {
        return this.NUM_BEAM_SEARCH_CALLS;
    }

    public int numSegsScored() {
        return this.NUM_SEGMENTS_SCORED;
    }

    public int numShiftsTried() {
        return this.NUM_SHIFTS_CONSIDERED;
    }
}

