/*
 * Decompiled with CFR 0.152.
 */
package ter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ter.TERsgml;
import ter.TERshift;

public class TERalignment {
    public Comparable[] ref;
    public Comparable[] hyp;
    public Comparable[] aftershift;
    public TERshift[] allshifts = null;
    public double numEdits = 0.0;
    public double numWords = 0.0;
    public char[] alignment = null;
    public String bestRef = "";
    public int numIns = 0;
    public int numDel = 0;
    public int numSub = 0;
    public int numSft = 0;
    public int numWsf = 0;

    public String toString() {
        int i;
        String s = "Original Ref: " + TERalignment.join(" ", this.ref) + "\nOriginal Hyp: " + TERalignment.join(" ", this.hyp) + "\nHyp After Shift: " + TERalignment.join(" ", this.aftershift);
        if (this.alignment != null) {
            s = String.valueOf(s) + "\nAlignment: (";
            i = 0;
            while (i < this.alignment.length) {
                s = String.valueOf(s) + this.alignment[i];
                ++i;
            }
            s = String.valueOf(s) + ")";
        }
        if (this.allshifts == null) {
            s = String.valueOf(s) + "\nNumShifts: 0";
        } else {
            s = String.valueOf(s) + "\nNumShifts: " + this.allshifts.length;
            i = 0;
            while (i < this.allshifts.length) {
                s = String.valueOf(s) + "\n  " + this.allshifts[i];
                ++i;
            }
        }
        s = String.valueOf(s) + "\nScore: " + this.score() + " (" + this.numEdits + "/" + this.numWords + ")";
        return s;
    }

    public String toMoreString() {
        String s = "Best Ref: " + TERalignment.join(" ", this.ref) + "\nOrig Hyp: " + TERalignment.join(" ", this.hyp) + "\n";
        s = String.valueOf(s) + this.getPraStr(this.ref, this.aftershift, this.alignment, this.allshifts, false);
        s = String.valueOf(s) + String.format("TER Score: %1$6.2f (%2$5.1f/%3$5.1f)\n", 100.0 * this.score(), this.numEdits, this.numWords);
        s = String.valueOf(s) + this.prtShift(this.ref, this.allshifts);
        return s;
    }

    public double score() {
        if (this.numWords <= 0.0 && this.numEdits > 0.0) {
            return 1.0;
        }
        if (this.numWords <= 0.0) {
            return 0.0;
        }
        return this.numEdits / this.numWords;
    }

    public static String join(String delim, Comparable[] arr) {
        if (arr == null) {
            return "";
        }
        if (delim == null) {
            delim = new String("");
        }
        String s = new String("");
        int i = 0;
        while (i < arr.length) {
            s = i == 0 ? String.valueOf(s) + arr[i] : String.valueOf(s) + delim + arr[i];
            ++i;
        }
        return s;
    }

    public static String join(String delim, char[] arr) {
        if (arr == null) {
            return "";
        }
        if (delim == null) {
            delim = new String("");
        }
        String s = new String("");
        int i = 0;
        while (i < arr.length) {
            s = i == 0 ? String.valueOf(s) + arr[i] : String.valueOf(s) + delim + arr[i];
            ++i;
        }
        return s;
    }

    public void scoreDetails() {
        int i;
        this.numSft = 0;
        this.numWsf = 0;
        this.numSub = 0;
        this.numDel = 0;
        this.numIns = 0;
        if (this.allshifts != null) {
            i = 0;
            while (i < this.allshifts.length) {
                this.numWsf += this.allshifts[i].size();
                ++i;
            }
            this.numSft = this.allshifts.length;
        }
        if (this.alignment != null) {
            i = 0;
            while (i < this.alignment.length) {
                switch (this.alignment[i]) {
                    case 'S': 
                    case 'T': {
                        ++this.numSub;
                        break;
                    }
                    case 'D': {
                        ++this.numDel;
                        break;
                    }
                    case 'I': {
                        ++this.numIns;
                    }
                }
                ++i;
            }
        }
    }

    public static void performShiftArray(HashMap hwords, int start, int end, int moveto, int capacity) {
        HashMap nhwords = new HashMap();
        if (moveto == -1) {
            TERalignment.copyHashWords(hwords, nhwords, start, end, 0);
            TERalignment.copyHashWords(hwords, nhwords, 0, start - 1, end - start + 1);
            TERalignment.copyHashWords(hwords, nhwords, end + 1, capacity, end + 1);
        } else if (moveto < start) {
            TERalignment.copyHashWords(hwords, nhwords, 0, moveto, 0);
            TERalignment.copyHashWords(hwords, nhwords, start, end, moveto + 1);
            TERalignment.copyHashWords(hwords, nhwords, moveto + 1, start - 1, end - start + moveto + 2);
            TERalignment.copyHashWords(hwords, nhwords, end + 1, capacity, end + 1);
        } else if (moveto > end) {
            TERalignment.copyHashWords(hwords, nhwords, 0, start - 1, 0);
            TERalignment.copyHashWords(hwords, nhwords, end + 1, moveto, start);
            TERalignment.copyHashWords(hwords, nhwords, start, end, start + moveto - end);
            TERalignment.copyHashWords(hwords, nhwords, moveto + 1, capacity, moveto + 1);
        } else {
            TERalignment.copyHashWords(hwords, nhwords, 0, start - 1, 0);
            TERalignment.copyHashWords(hwords, nhwords, end + 1, end + moveto - start, start);
            TERalignment.copyHashWords(hwords, nhwords, start, end, moveto);
            TERalignment.copyHashWords(hwords, nhwords, end + moveto - start + 1, capacity, end + moveto - start + 1);
        }
        hwords.clear();
        hwords.putAll(nhwords);
    }

    private String prtShift(Comparable[] ref, TERshift[] allshifts) {
        String to_return = "";
        String direction = "";
        if (allshifts != null) {
            int i = 0;
            while (i < allshifts.length) {
                int dist;
                int nend;
                int nstart;
                TERshift[] oneshift = new TERshift[1];
                int ostart = allshifts[i].start;
                int odest = allshifts[i].newloc;
                int oend = allshifts[i].end;
                if (odest >= oend) {
                    nstart = odest + 1 - allshifts[i].size();
                    nend = nstart + allshifts[i].size() - 1;
                    dist = odest - oend;
                    direction = "right";
                } else {
                    nstart = odest + 1;
                    nend = nstart + allshifts[i].size() - 1;
                    dist = ostart - odest - 1;
                    direction = "left";
                }
                to_return = String.valueOf(to_return) + "\nShift " + allshifts[i].shifted + " " + dist + " words " + direction;
                oneshift[0] = new TERshift(ostart, oend, allshifts[i].moveto, odest);
                to_return = String.valueOf(to_return) + this.getPraStr(ref, allshifts[i].aftershift, allshifts[i].alignment, oneshift, true);
                ++i;
            }
            to_return = String.valueOf(to_return) + "\n";
        }
        return to_return;
    }

    private String getPraStr(Comparable[] ref, Comparable[] aftershift, char[] alignment, TERshift[] allshifts, boolean shiftonly) {
        String to_return = "";
        String rstr = "";
        String hstr = "";
        String estr = "";
        String sstr = "";
        HashMap align_info = new HashMap();
        ArrayList<Integer> shift_dists = new ArrayList<Integer>();
        int anum = 1;
        int ind_start = 0;
        int ind_end = 1;
        int ind_from = 2;
        int ind_in = 3;
        int slen = 0;
        int non_inserr = 0;
        if (allshifts != null) {
            int i = 0;
            while (i < allshifts.length) {
                ArrayList<Integer> al;
                Object val;
                int dist;
                int nfrom;
                int nend;
                int nstart;
                int ostart = allshifts[i].start;
                int oend = allshifts[i].end;
                int odest = allshifts[i].newloc;
                slen = allshifts[i].size();
                if (odest >= oend) {
                    nstart = odest + 1 - slen;
                    nend = nstart + slen - 1;
                    nfrom = ostart;
                    dist = odest - oend;
                } else {
                    nstart = odest + 1;
                    nend = nstart + slen - 1;
                    nfrom = ostart + slen;
                    dist = (ostart - odest - 1) * -1;
                }
                shift_dists.add(dist);
                if (anum > 1) {
                    TERalignment.performShiftArray(align_info, ostart, oend, odest, alignment.length);
                }
                if ((val = align_info.get(String.valueOf(nstart) + "-" + ind_start)) == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(String.valueOf(nstart) + "-" + ind_start, al);
                } else {
                    al = (ArrayList<Integer>)val;
                    al.add(anum);
                }
                val = align_info.get(String.valueOf(nend) + "-" + ind_end);
                if (val == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(String.valueOf(nend) + "-" + ind_end, al);
                } else {
                    al = (ArrayList<Integer>)val;
                    al.add(anum);
                }
                val = align_info.get(String.valueOf(nfrom) + "-" + ind_from);
                if (val == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(String.valueOf(nfrom) + "-" + ind_from, al);
                } else {
                    al = (ArrayList<Integer>)val;
                    al.add(anum);
                }
                if (slen > 0) {
                    int j = nstart;
                    while (j <= nend) {
                        ArrayList<Integer> al2;
                        val = align_info.get(String.valueOf(j) + "-" + ind_in);
                        if (val == null) {
                            al2 = new ArrayList<Integer>();
                            al2.add(anum);
                            align_info.put(String.valueOf(j) + "-" + ind_in, al2);
                        } else {
                            al2 = (ArrayList<Integer>)val;
                            al2.add(anum);
                        }
                        ++j;
                    }
                }
                ++anum;
                ++i;
            }
        }
        int hyp_idx = 0;
        int ref_idx = 0;
        Object val = null;
        if (alignment != null) {
            int i = 0;
            while (i < alignment.length) {
                int k;
                String s;
                int j;
                String shift_in_str = "";
                String ref_wd = ref_idx < ref.length ? String.valueOf(ref[ref_idx]) : "";
                String hyp_wd = hyp_idx < this.hyp.length ? String.valueOf(aftershift[hyp_idx]) : "";
                int l = 0;
                if (alignment[i] != 'D') {
                    ArrayList list;
                    val = align_info.get(String.valueOf(hyp_idx) + "-" + ind_from);
                    if (val != null) {
                        list = val;
                        j = 0;
                        while (j < list.size()) {
                            s = "" + list.get(j);
                            hstr = String.valueOf(hstr) + " @";
                            rstr = String.valueOf(rstr) + "  ";
                            estr = String.valueOf(estr) + "  ";
                            sstr = String.valueOf(sstr) + " " + s;
                            k = 1;
                            while (k < s.length()) {
                                hstr = String.valueOf(hstr) + " ";
                                rstr = String.valueOf(rstr) + " ";
                                estr = String.valueOf(estr) + " ";
                                ++k;
                            }
                            ++j;
                        }
                    }
                    if ((val = align_info.get(String.valueOf(hyp_idx) + "-" + ind_start)) != null) {
                        list = val;
                        j = 0;
                        while (j < list.size()) {
                            s = "" + list.get(j);
                            hstr = String.valueOf(hstr) + " [";
                            rstr = String.valueOf(rstr) + "  ";
                            estr = String.valueOf(estr) + "  ";
                            sstr = String.valueOf(sstr) + " " + s;
                            k = 1;
                            while (k < s.length()) {
                                hstr = String.valueOf(hstr) + " ";
                                rstr = String.valueOf(rstr) + " ";
                                estr = String.valueOf(estr) + " ";
                                ++k;
                            }
                            ++j;
                        }
                    }
                    if (slen > 0 && (val = align_info.get(String.valueOf(hyp_idx) + "-" + ind_in)) != null) {
                        shift_in_str = TERsgml.join(",", val);
                    }
                }
                switch (alignment[i]) {
                    case ' ': {
                        l = Math.max(ref_wd.length(), hyp_wd.length());
                        hstr = String.valueOf(hstr) + " " + hyp_wd;
                        rstr = String.valueOf(rstr) + " " + ref_wd;
                        estr = String.valueOf(estr) + " ";
                        sstr = String.valueOf(sstr) + " ";
                        int j2 = 0;
                        while (j2 < l) {
                            if (hyp_wd.length() <= j2) {
                                hstr = String.valueOf(hstr) + " ";
                            }
                            if (ref_wd.length() <= j2) {
                                rstr = String.valueOf(rstr) + " ";
                            }
                            estr = String.valueOf(estr) + " ";
                            sstr = String.valueOf(sstr) + " ";
                            ++j2;
                        }
                        ++hyp_idx;
                        ++ref_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'S': 
                    case 'T': {
                        l = Math.max(ref_wd.length(), Math.max(hyp_wd.length(), Math.max(1, shift_in_str.length())));
                        hstr = String.valueOf(hstr) + " " + hyp_wd;
                        rstr = String.valueOf(rstr) + " " + ref_wd;
                        if (hyp_wd.equals("") || ref_wd.equals("")) {
                            System.out.println("unexpected empty");
                        }
                        estr = String.valueOf(estr) + " " + alignment[i];
                        sstr = String.valueOf(sstr) + " " + shift_in_str;
                        int j3 = 0;
                        while (j3 < l) {
                            if (hyp_wd.length() <= j3) {
                                hstr = String.valueOf(hstr) + " ";
                            }
                            if (ref_wd.length() <= j3) {
                                rstr = String.valueOf(rstr) + " ";
                            }
                            if (j3 > 0) {
                                estr = String.valueOf(estr) + " ";
                            }
                            if (j3 >= shift_in_str.length()) {
                                sstr = String.valueOf(sstr) + " ";
                            }
                            ++j3;
                        }
                        ++ref_idx;
                        ++hyp_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'D': {
                        l = ref_wd.length();
                        hstr = String.valueOf(hstr) + " ";
                        rstr = String.valueOf(rstr) + " " + ref_wd;
                        estr = String.valueOf(estr) + " D";
                        sstr = String.valueOf(sstr) + " ";
                        int j4 = 0;
                        while (j4 < l) {
                            hstr = String.valueOf(hstr) + "*";
                            if (j4 > 0) {
                                estr = String.valueOf(estr) + " ";
                            }
                            sstr = String.valueOf(sstr) + " ";
                            ++j4;
                        }
                        ++ref_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'I': {
                        l = Math.max(hyp_wd.length(), shift_in_str.length());
                        hstr = String.valueOf(hstr) + " " + hyp_wd;
                        rstr = String.valueOf(rstr) + " ";
                        estr = String.valueOf(estr) + " I";
                        sstr = String.valueOf(sstr) + " " + shift_in_str;
                        int j5 = 0;
                        while (j5 < l) {
                            rstr = String.valueOf(rstr) + "*";
                            if (j5 >= hyp_wd.length()) {
                                hstr = String.valueOf(hstr) + " ";
                            }
                            if (j5 > 0) {
                                estr = String.valueOf(estr) + " ";
                            }
                            if (j5 >= shift_in_str.length()) {
                                sstr = String.valueOf(sstr) + " ";
                            }
                            ++j5;
                        }
                        ++hyp_idx;
                    }
                }
                if (alignment[i] != 'D' && (val = align_info.get(String.valueOf(hyp_idx - 1) + "-" + ind_end)) != null) {
                    ArrayList list = val;
                    j = 0;
                    while (j < list.size()) {
                        s = "" + list.get(j);
                        hstr = String.valueOf(hstr) + " ]";
                        rstr = String.valueOf(rstr) + "  ";
                        estr = String.valueOf(estr) + "  ";
                        sstr = String.valueOf(sstr) + " " + s;
                        k = 1;
                        while (k < s.length()) {
                            hstr = String.valueOf(hstr) + " ";
                            rstr = String.valueOf(rstr) + " ";
                            estr = String.valueOf(estr) + " ";
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        String indent = "";
        if (shiftonly) {
            indent = " ";
        }
        to_return = String.valueOf(to_return) + "\n" + indent + "REF: " + rstr;
        to_return = String.valueOf(to_return) + "\n" + indent + "HYP: " + hstr;
        if (!shiftonly) {
            to_return = String.valueOf(to_return) + "\n" + indent + "EVAL:" + estr;
            to_return = String.valueOf(to_return) + "\n" + indent + "SHFT:" + sstr;
        }
        to_return = String.valueOf(to_return) + "\n";
        return to_return;
    }

    private static void copyHashWords(HashMap<String, List<?>> ohwords, HashMap<String, List<?>> nhwords, int start, int end, int nstart) {
        int ind_start = 0;
        boolean ind_end = true;
        int ind_from = 2;
        int ind_in = 3;
        int k = nstart;
        int i = start;
        while (i <= end) {
            int j = ind_start;
            while (j <= ind_in) {
                List<?> val = ohwords.get(String.valueOf(i) + "-" + j);
                if (val != null) {
                    nhwords.put(String.valueOf(k) + "-" + j, val);
                }
                ++j;
            }
            ++k;
            ++i;
        }
    }
}

