/*
 * Decompiled with CFR 0.152.
 */
package multeval.util;

import java.util.Arrays;
import java.util.List;
import multeval.util.ArrayUtils;

public class MathUtils {
    public static final double SQRT_2 = Math.sqrt(2.0);

    public static double factorial(int val) {
        double result = 1.0;
        for (int i = 2; i <= val; ++i) {
            result *= (double)i;
        }
        return result;
    }

    public static double gamma(int alpha) {
        return MathUtils.factorial(alpha - 1);
    }

    public static double average(List<Double> observations) {
        double total = 0.0;
        for (double d : observations) {
            total += d;
        }
        return total / (double)observations.size();
    }

    public static double average(double[] data) {
        double total = 0.0;
        for (double d : data) {
            total += d;
        }
        return total / (double)data.length;
    }

    public static double variance(List<Double> observations) {
        double mean = MathUtils.average(observations);
        double varSum = 0.0;
        for (double d : observations) {
            varSum += (d - mean) * (d - mean);
        }
        return varSum / (double)observations.size();
    }

    public static double variance(double[] observations) {
        double mean = MathUtils.average(observations);
        double varSum = 0.0;
        for (double d : observations) {
            varSum += (d - mean) * (d - mean);
        }
        return varSum / (double)(observations.length - 1);
    }

    public static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (z >= 0.0) {
            return ans;
        }
        return -ans;
    }

    public static double min(double[] samples) {
        double result = Double.MAX_VALUE;
        for (double d : samples) {
            result = Math.min(result, d);
        }
        return result;
    }

    public static double max(double[] samples) {
        double result = Double.MIN_VALUE;
        for (double d : samples) {
            result = Math.max(result, d);
        }
        return result;
    }

    public static double stddev(double[] observations) {
        return Math.sqrt(MathUtils.variance(observations));
    }

    public static int medianIndexInSorted(double[] arr) {
        Arrays.sort(arr);
        if (arr.length < 2) {
            return 0;
        }
        if (arr.length % 2 == 0) {
            return arr.length / 2;
        }
        return (arr.length - 1) / 2;
    }

    public static int medianIndex(double[] arr) {
        if (arr.length < 2) {
            return 0;
        }
        double[] copy = Arrays.copyOf(arr, arr.length);
        Arrays.sort(copy);
        int copyIdx = copy.length % 2 == 0 ? copy.length / 2 : (copy.length - 1) / 2;
        double median = copy[copyIdx];
        int arrIdx = ArrayUtils.indexOf(arr, median);
        return arrIdx;
    }
}

