/*
 * Decompiled with CFR 0.152.
 */
package multeval.significance;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import multeval.metrics.Metric;
import multeval.metrics.SuffStats;
import multeval.parallel.MetricWorkerPool;

public class BootstrapResampler {
    private final Random random = new Random();
    private final int threads;
    private final List<Metric<?>> masterMetrics;
    private final List<List<SuffStats<?>>> suffStats;
    private int totalDataPoints;

    public BootstrapResampler(int threads, List<Metric<?>> metrics, List<List<SuffStats<?>>> suffStats) {
        Preconditions.checkArgument(metrics.size() > 0, "Must have at least one metric.");
        Preconditions.checkArgument(suffStats.size() > 0, "Must have at least one data point.");
        this.threads = threads;
        this.masterMetrics = metrics;
        this.suffStats = suffStats;
        this.totalDataPoints = suffStats.get(0).size();
        Preconditions.checkArgument(this.totalDataPoints > 0, "Need more than zero data points.");
    }

    public List<double[]> resample(int numSamples) throws InterruptedException {
        final ArrayList<double[]> metricValues = new ArrayList<double[]>(this.masterMetrics.size());
        for (int i = 0; i < this.masterMetrics.size(); ++i) {
            metricValues.add(new double[numSamples]);
        }
        MetricWorkerPool<Integer, Locals> workers = new MetricWorkerPool<Integer, Locals>(this.threads, (Supplier)new Supplier<Locals>(){

            @Override
            public Locals get() {
                return new Locals(BootstrapResampler.this.masterMetrics, BootstrapResampler.this.totalDataPoints);
            }
        }){

            @Override
            public void doWork(Locals locals, Integer iSample) {
                BootstrapResampler.this.chooseSampleMembers(BootstrapResampler.this.totalDataPoints, locals.sampleMembers);
                for (int iMetric = 0; iMetric < BootstrapResampler.this.masterMetrics.size(); ++iMetric) {
                    double score;
                    SuffStats summedStats = BootstrapResampler.sumStats(locals.sampleMembers, iMetric, BootstrapResampler.this.suffStats);
                    Metric<?> metric = locals.metrics.get(iMetric);
                    ((double[])metricValues.get((int)iMetric))[iSample.intValue()] = score = metric.scoreStats(summedStats);
                }
            }
        };
        workers.start();
        for (int iSample = 0; iSample < numSamples; ++iSample) {
            workers.addTask(iSample);
        }
        workers.waitForCompletion();
        return metricValues;
    }

    private static SuffStats<?> sumStats(int[] sampleMembers, int iMetric, List<List<SuffStats<?>>> ss) {
        SuffStats<?> summedStats = ss.get(iMetric).get(0).create();
        for (int dataIdx : sampleMembers) {
            summedStats.add(ss.get(iMetric).get(dataIdx));
        }
        return summedStats;
    }

    private void chooseSampleMembers(int totalPointsAvailable, int[] sampleMembersOut) {
        for (int i = 0; i < sampleMembersOut.length; ++i) {
            sampleMembersOut[i] = this.random.nextInt(totalPointsAvailable);
        }
    }

    private static class Locals {
        public final int[] sampleMembers;
        public final List<Metric<?>> metrics;

        public Locals(List<Metric<?>> masterMetrics, int sampleSize) {
            this.sampleMembers = new int[sampleSize];
            this.metrics = new ArrayList(masterMetrics.size());
            for (Metric<?> metric : masterMetrics) {
                this.metrics.add(metric.threadClone());
            }
        }
    }
}

