/*
 * Decompiled with CFR 0.152.
 */
package multeval.parallel;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class MetricWorkerPool<Task, ThreadLocals> {
    private final int threads;
    private final Supplier<ThreadLocals> threadLocalSupplier;
    private final int chunkSize;
    private final List<Task> POISON = ImmutableList.of();
    private List<Task> curChunk;
    private final ArrayList<Thread> workers;
    private final ArrayBlockingQueue<List<Task>> q;
    public static final int DEFAULT_CHUNK_SIZE = 100;

    public MetricWorkerPool(int threads, Supplier<ThreadLocals> threadLocals) {
        this(threads, threadLocals, 100);
    }

    public MetricWorkerPool(int threads, Supplier<ThreadLocals> threadLocals, int chunkSize) {
        this.threads = threads;
        this.threadLocalSupplier = threadLocals;
        this.chunkSize = chunkSize;
        this.curChunk = new ArrayList<Task>(chunkSize);
        this.workers = new ArrayList(threads);
        this.q = new ArrayBlockingQueue(threads * 100);
    }

    public void start() {
        for (int iThread = 0; iThread < this.threads; ++iThread) {
            Thread thread = new Thread(){
                ThreadLocals locals;
                {
                    this.locals = MetricWorkerPool.this.threadLocalSupplier.get();
                }

                @Override
                public void run() {
                    try {
                        List chunk = (List)MetricWorkerPool.this.q.take();
                        while (!((Object)chunk).equals(MetricWorkerPool.this.POISON)) {
                            for (Object task : chunk) {
                                MetricWorkerPool.this.doWork(this.locals, task);
                            }
                            chunk = (List)MetricWorkerPool.this.q.take();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            this.workers.add(thread);
            thread.start();
        }
    }

    public void addTask(Task t) throws InterruptedException {
        if (this.curChunk.size() == this.chunkSize) {
            this.q.put(this.curChunk);
            this.curChunk = new ArrayList<Task>(this.chunkSize);
        }
        this.curChunk.add(t);
    }

    public void waitForCompletion() throws InterruptedException {
        if (this.curChunk.size() > 0) {
            this.q.put(this.curChunk);
        }
        for (int iThread = 0; iThread < this.threads; ++iThread) {
            this.q.put(this.POISON);
        }
        for (Thread t : this.workers) {
            t.join();
        }
    }

    public abstract void doWork(ThreadLocals var1, Task var2);
}

