/*
 * Decompiled with CFR 0.152.
 */
package multeval.output;

import java.io.PrintStream;
import multeval.ResultsManager;

public class AsciiTable {
    public void write(ResultsManager results, PrintStream out) {
        String[] columns = new String[results.metricNames.length + 1];
        columns[0] = String.format("n=%d", results.numOptRuns);
        for (int i = 0; i < results.metricNames.length; ++i) {
            columns[i + 1] = results.metricNames[i] + " (s_sel/s_opt/p)";
        }
        this.print(out, columns);
        String[] metrics = results.metricNames;
        String[] systems = results.sysNames;
        int sysCount = systems.length;
        for (int iSys = 0; iSys < sysCount; ++iSys) {
            columns[0] = systems[iSys];
            for (int iMetric = 0; iMetric < metrics.length; ++iMetric) {
                double avg = results.get(iMetric, iSys, ResultsManager.Type.AVG);
                double sSel = results.get(iMetric, iSys, ResultsManager.Type.RESAMPLED_STDDEV_AVG);
                double sTest = results.get(iMetric, iSys, ResultsManager.Type.STDDEV);
                if (iSys == 0) {
                    if (results.numOptRuns > 1) {
                        columns[iMetric + 1] = String.format("%2.1f (%.1f/%.1f/-)", avg, sSel, sTest);
                        continue;
                    }
                    columns[iMetric + 1] = String.format("%2.1f (%.1f/*/-)", avg, sSel);
                    continue;
                }
                double p = results.get(iMetric, iSys, ResultsManager.Type.P_VALUE);
                columns[iMetric + 1] = results.numOptRuns > 1 ? String.format("%2.1f (%.1f/%.1f/%.2f)", avg, sSel, sTest, p) : String.format("%2.1f (%.1f/*/**)", avg, sSel);
            }
            this.print(out, columns);
        }
        if (results.numOptRuns < 2) {
            out.println("  *  Indicates no estimate of optimizer instability due to single optimizer run. Consider multiple optimizer runs.");
            if (sysCount > 1) {
                out.println("  ** Indicates no p-value due to single optimizer run. Consider multiple optimizer runs.");
            }
        }
        out.flush();
    }

    private void print(PrintStream out, String[] columns) {
        out.print(String.format("%-15s", columns[0]));
        for (int i = 1; i < columns.length; ++i) {
            out.print(String.format("%-23s", columns[i]));
        }
        out.println();
    }
}

