/*
 * Decompiled with CFR 0.152.
 */
package multeval.metrics;

import com.google.common.base.Preconditions;
import jannopts.ConfigurationException;
import jannopts.Configurator;
import jannopts.Option;
import java.util.List;
import multeval.metrics.IntStats;
import multeval.metrics.Metric;
import multeval.util.LibUtil;
import ter.TERalignment;
import ter.TERcalc;
import ter.TERcost;

public class TER
extends Metric<IntStats> {
    @Option(shortName="P", longName="ter.punctuation", usage="Use punctuation in TER?", defaultValue="false")
    boolean punctuation;
    @Option(shortName="b", longName="ter.beamWidth", usage="Beam width for TER", defaultValue="20")
    int beamWidth;
    @Option(shortName="d", longName="ter.maxShiftDistance", usage="Maximum shift distance for TER", defaultValue="50")
    int maxShiftDistance;
    @Option(shortName="M", longName="ter.matchCost", usage="Match cost for TER", defaultValue="0.0")
    float matchCost;
    @Option(shortName="D", longName="ter.deleteCost", usage="Delete cost for TER", defaultValue="1.0")
    float deleteCost;
    @Option(shortName="B", longName="ter.substituteCost", usage="Substitute cost for TER", defaultValue="1.0")
    float substituteCost;
    @Option(shortName="I", longName="ter.insertCost", usage="Insert cost for TER", defaultValue="1.0")
    float insertCost;
    @Option(shortName="T", longName="ter.shiftCost", usage="Shift cost for TER", defaultValue="1.0")
    float shiftCost;
    private TERcost costfunc;
    private TERcalc calc = new TERcalc();
    private Configurator opts = null;

    @Override
    public String getMetricDescription() {
        return "Translation Error Rate (TER) V0.8.0";
    }

    @Override
    public IntStats stats(String hyp, List<String> refs) {
        double totwords = 0.0;
        TERalignment bestResult = null;
        this.calc.setRefLen(refs);
        for (int i = 0; i < refs.size(); ++i) {
            String ref = refs.get(i);
            TERalignment alignResult = this.calc.TER(hyp, ref, this.costfunc);
            if (bestResult == null || bestResult.numEdits > alignResult.numEdits) {
                bestResult = alignResult;
            }
            totwords += alignResult.numWords;
        }
        bestResult.numWords = totwords / (double)refs.size();
        IntStats result = new IntStats(2);
        result.arr[0] = (int)bestResult.numEdits;
        result.arr[1] = (int)bestResult.numWords;
        return result;
    }

    @Override
    public double score(IntStats suffStats) {
        Preconditions.checkArgument(suffStats.arr.length == 2, "TER sufficient stats must be of length 2");
        int edits = suffStats.arr[0];
        int words = suffStats.arr[1];
        double score = (double)edits / (double)words;
        return score * 100.0;
    }

    public String toString() {
        return "TER";
    }

    @Override
    public void configure(Configurator opts) throws ConfigurationException {
        this.opts = opts;
        LibUtil.checkLibrary("ter.TERpara", "TER");
        opts.configure(this);
        this.configureLibTer();
    }

    private void configureLibTer() {
        this.costfunc = new TERcost();
        this.costfunc._delete_cost = this.deleteCost;
        this.costfunc._insert_cost = this.insertCost;
        this.costfunc._shift_cost = this.shiftCost;
        this.costfunc._match_cost = this.matchCost;
        this.costfunc._substitute_cost = this.substituteCost;
        this.calc.setPunct(this.punctuation);
        this.calc.setBeamWidth(this.beamWidth);
        this.calc.setShiftDist(this.maxShiftDistance);
    }

    @Override
    public boolean isBiggerBetter() {
        return false;
    }

    @Override
    public Metric<?> threadClone() {
        TER ter = new TER();
        try {
            this.opts.configure(ter);
            ter.configureLibTer();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return ter;
    }
}

