/*
 * Decompiled with CFR 0.152.
 */
package multeval.metrics;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.primitives.Doubles;
import edu.cmu.meteor.aligner.Match;
import edu.cmu.meteor.scorer.MeteorConfiguration;
import edu.cmu.meteor.scorer.MeteorScorer;
import edu.cmu.meteor.scorer.MeteorStats;
import edu.cmu.meteor.util.Constants;
import jannopts.ConfigurationException;
import jannopts.Configurator;
import jannopts.Option;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import multeval.metrics.METEORStats;
import multeval.metrics.Metric;
import multeval.util.LibUtil;

public class METEOR
extends Metric<METEORStats> {
    @Option(shortName="l", longName="meteor.language", usage="Two-letter language code of a supported METEOR language (e.g. 'en')")
    String language;
    @Option(shortName="t", longName="meteor.task", usage="One of: rank adq hter tune (Rank is generally a good choice)", defaultValue="rank")
    String task;
    @Option(shortName="p", longName="meteor.params", usage="Custom parameters of the form 'alpha beta gamma' (overrides default)", arrayDelim=" ", required=false)
    double[] params;
    @Option(shortName="m", longName="meteor.modules", usage="Specify modules. (overrides default) Any of: exact stem synonym paraphrase", arrayDelim=" ", required=false)
    String[] modules;
    @Option(shortName="w", longName="meteor.weights", usage="Specify module weights (overrides default)", arrayDelim=" ", required=false)
    double[] moduleWeights;
    @Option(shortName="x", longName="meteor.beamSize", usage="Specify beam size (overrides default)", defaultValue="40")
    int beamSize;
    @Option(shortName="s", longName="meteor.synonymDirectory", usage="If default is not desired (NOTE: This option has a different short flag than stand-alone METEOR)", required=false)
    String synonymDirectory;
    @Option(shortName="a", longName="meteor.paraphraseFile", usage="If default is not desired", required=false)
    String paraphraseFile;
    @Option(shortName="k", longName="meteor.keepPunctuation", usage="Consider punctuation when aligning sentences (if false, the meteor tokenizer will be run, after which punctuation will be removed)", defaultValue="true")
    boolean keepPunctuation;
    public static final String[] SUBMETRIC_NAMES = new String[]{"prec", "rec", "frag"};
    private MeteorScorer scorer;

    @Override
    public String getMetricDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("Meteor V1.4");
        builder.append(" " + this.language);
        builder.append(" on " + this.task + " task");
        if (this.modules == null) {
            builder.append(" with all default modules");
        } else {
            builder.append(" with modules " + Joiner.on(", ").join(this.modules));
        }
        if (this.keepPunctuation) {
            builder.append(" NOT");
        }
        builder.append(" ignoring punctuation");
        return builder.toString();
    }

    @Override
    public void configure(Configurator opts) throws ConfigurationException {
        LibUtil.checkLibrary("edu.cmu.meteor.scorer.MeteorScorer", "METEOR");
        System.err.println("Using METEOR Version 1.4");
        opts.configure(this);
        if (Constants.getLanguageID((String)Constants.normLanguageName((String)this.language)) == 99 && Constants.getTaskID((String)this.task) != 99) {
            throw new ConfigurationException("Unrecognized METEOR language: " + this.language);
        }
        if (Constants.getTaskID((String)this.task) == -1) {
            throw new ConfigurationException("Unrecognized METEOR task: " + this.task);
        }
        MeteorConfiguration config = new MeteorConfiguration();
        config.setLanguage(this.language);
        config.setTask(this.task);
        if (this.params != null) {
            config.setParameters(new ArrayList<Double>(Doubles.asList(this.params)));
        }
        if (this.moduleWeights != null) {
            config.setModuleWeights(new ArrayList<Double>(Doubles.asList(this.moduleWeights)));
        }
        if (this.modules != null) {
            List<String> moduleList = Arrays.asList(this.modules);
            config.setModulesByName(new ArrayList<String>(moduleList));
            if (config.getModuleWeights().size() != this.modules.length) {
                throw new RuntimeException("You provided " + this.modules.length + " modules and " + config.getModuleWeights().size() + " module weights");
            }
        }
        config.setBeamSize(this.beamSize);
        if (this.synonymDirectory != null) {
            try {
                config.setSynDirURL(new File(this.synonymDirectory).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        if (this.paraphraseFile != null) {
            try {
                config.setParaFileURL(new File(this.paraphraseFile).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        if (this.keepPunctuation) {
            config.setNormalization(0);
        } else {
            config.setNormalization(3);
        }
        System.err.println("Loading METEOR paraphrase table...");
        Stopwatch watch = new Stopwatch();
        watch.start();
        this.scorer = new MeteorScorer(config);
        watch.stop();
        System.err.println("Loaded METEOR in " + watch.toString(3));
    }

    @Override
    public METEORStats stats(String hyp, List<String> refs) {
        MeteorStats result = this.scorer.getMeteorStats(hyp, new ArrayList<String>(refs));
        return new METEORStats(result);
    }

    @Override
    public double score(METEORStats suffStats) {
        this.scorer.computeMetrics(suffStats.meteorStats);
        return suffStats.meteorStats.score * 100.0;
    }

    @Override
    public double[] scoreSubmetrics(METEORStats suffStats) {
        MeteorStats stats = suffStats.meteorStats;
        this.scorer.computeMetrics(stats);
        return new double[]{stats.precision, stats.recall, stats.fragPenalty};
    }

    @Override
    public String[] getSubmetricNames() {
        return SUBMETRIC_NAMES;
    }

    public Multiset<String> getUnmatchedHypWords(METEORStats stats) {
        ArrayList hypWords = stats.meteorStats.alignment.words1;
        HashMultiset<String> result = HashMultiset.create(hypWords);
        for (Match m : stats.meteorStats.alignment.matches) {
            if (m == null) continue;
            int hypMatchStart = m.matchStart;
            int hypMatchLen = m.matchLength;
            for (int i = 0; i < hypMatchLen; ++i) {
                String matchedHypWord = (String)hypWords.get(hypMatchStart + i);
                result.remove(matchedHypWord);
            }
        }
        return result;
    }

    public Multiset<String> getUnmatchedRefWords(METEORStats stats) {
        ArrayList refWords = stats.meteorStats.alignment.words2;
        HashMultiset<String> result = HashMultiset.create(refWords);
        for (Match m : stats.meteorStats.alignment.matches) {
            if (m == null) continue;
            int refMatchStart = m.start;
            int refMatchLen = m.length;
            for (int i = 0; i < refMatchLen; ++i) {
                String matchedRefWord = (String)refWords.get(refMatchStart + i);
                result.remove(matchedRefWord);
            }
        }
        return result;
    }

    public String toString() {
        return "METEOR";
    }

    @Override
    public boolean isBiggerBetter() {
        return true;
    }

    @Override
    public Metric<?> threadClone() {
        METEOR metric = new METEOR();
        metric.scorer = new MeteorScorer(this.scorer);
        return metric;
    }
}

