/*
 * Decompiled with CFR 0.152.
 */
package multeval.metrics;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import jannopts.ConfigurationException;
import jannopts.Configurator;
import java.util.ArrayList;
import java.util.List;
import jbleu.JBLEU;
import multeval.metrics.BLEU;
import multeval.metrics.IntStats;
import multeval.metrics.Metric;

public class Length
extends Metric<IntStats> {
    @Override
    public String getMetricDescription() {
        return "Hypothesis length over reference length as a percent";
    }

    @Override
    public IntStats stats(String hyp, List<String> refs) {
        ArrayList<String> hypToks = Lists.newArrayList(Splitter.on(CharMatcher.BREAKING_WHITESPACE).split(hyp));
        List<List<String>> tokRefs = BLEU.tokenizeRefs(refs);
        int verbosity = 0;
        int iRef = JBLEU.pickReference(hypToks, tokRefs, verbosity);
        IntStats result = new IntStats(2);
        result.arr[0] = hypToks.size();
        result.arr[1] = tokRefs.get(iRef).size();
        return result;
    }

    @Override
    public double score(IntStats suffStats) {
        int hypLen = suffStats.arr[0];
        int refLen = suffStats.arr[1];
        return (double)hypLen / (double)refLen * 100.0;
    }

    public String toString() {
        return "Length";
    }

    @Override
    public void configure(Configurator opts) throws ConfigurationException {
        opts.configure(this);
    }

    @Override
    public boolean isBiggerBetter() {
        return true;
    }
}

