/*
 * Decompiled with CFR 0.152.
 */
package multeval.analysis;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SentFormatter {
    private String[] metricNames;
    private String[] submetricNames;

    public SentFormatter(String[] metricNames, String[] submetricNames) {
        this.metricNames = metricNames;
        this.submetricNames = submetricNames;
    }

    public void write(List<String> hyps, List<List<String>> refs, double[][] sentMetricScores, double[][] sentSubmetricScores, PrintWriter out) {
        ArrayList<HypItem> list = new ArrayList<HypItem>(hyps.size());
        for (int i = 0; i < hyps.size(); ++i) {
            list.add(new HypItem(i, refs.get(i), hyps.get(i), sentMetricScores[i], sentSubmetricScores[i]));
        }
        for (HypItem item : list) {
            out.printf("%d ||| %s |||", item.id, item.hyp);
            for (int iMetric = 0; iMetric < this.metricNames.length; ++iMetric) {
                out.printf(" %s=%.2f", this.metricNames[iMetric], item.metricScores[iMetric]);
            }
            out.print(" |||");
            for (int iSubmetric = 0; iSubmetric < this.submetricNames.length; ++iSubmetric) {
                out.printf(" %s=%.2f", this.submetricNames[iSubmetric], item.submetricScores[iSubmetric]);
            }
            out.println();
        }
    }

    private static class HypItem {
        public final int id;
        public final List<String> refs;
        public final String hyp;
        public final double[] metricScores;
        public final double[] submetricScores;

        public HypItem(int id, List<String> refs, String hyp, double[] metricScores, double[] submetricScores) {
            this.id = id;
            this.hyp = hyp;
            this.refs = refs;
            this.metricScores = metricScores;
            this.submetricScores = submetricScores;
        }
    }
}

