/*
 * Decompiled with CFR 0.152.
 */
package multeval.analysis;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffRanker {
    private String[] metricNames;

    public DiffRanker(String[] metricNames) {
        this.metricNames = metricNames;
    }

    public void write(List<String> hypsMedianBaseline, List<String> hypsMedianSys, List<List<String>> refs, double[][] sentMetricScoresBaseline, double[][] sentMetricScoresSys, final int sortByMetric, PrintWriter out) {
        ArrayList<HypItem> list = new ArrayList<HypItem>(hypsMedianBaseline.size());
        for (int i = 0; i < hypsMedianBaseline.size(); ++i) {
            list.add(new HypItem(i, refs.get(i), hypsMedianBaseline.get(i), hypsMedianSys.get(i), sentMetricScoresBaseline[i], sentMetricScoresSys[i]));
        }
        Collections.sort(list, new Comparator<HypItem>(){

            @Override
            public int compare(HypItem hypA, HypItem hypB) {
                double diffB;
                double diffA = hypA.diff(sortByMetric);
                return -(diffA < (diffB = hypB.diff(sortByMetric)) ? -1 : (diffA == diffB ? 0 : 1));
            }
        });
        for (HypItem item : list) {
            out.printf("SENT %d\t", item.id);
            out.printf("%s: %.1f -> %.1f = %.1f", this.metricNames[sortByMetric], item.metricScoresBaseline[sortByMetric], item.metricScoresSys[sortByMetric], item.diff(sortByMetric));
            for (int iMetric = 0; iMetric < this.metricNames.length; ++iMetric) {
                if (iMetric == sortByMetric) continue;
                out.printf("\t%s: %.1f -> %.1f = %.1f", this.metricNames[iMetric], item.metricScoresBaseline[iMetric], item.metricScoresSys[iMetric], item.diff(iMetric));
            }
            out.println();
            out.printf("%s-median-baseline: %s", this.metricNames[sortByMetric], item.hypBaseline);
            out.println();
            out.printf("%s-median-variant: %s", this.metricNames[sortByMetric], item.hypSys);
            out.println();
            for (int iRef = 0; iRef < item.refs.size(); ++iRef) {
                out.printf("ref%d: %s", iRef + 1, item.refs.get(iRef));
                out.println();
            }
            out.println();
        }
    }

    private static class HypItem {
        public final int id;
        public final List<String> refs;
        public final String hypBaseline;
        public final String hypSys;
        public final double[] metricScoresBaseline;
        public final double[] metricScoresSys;

        public HypItem(int id, List<String> refs, String hypBaseline, String hypSys, double[] metricScoresBaseline, double[] metricScoresSys) {
            this.id = id;
            this.hypBaseline = hypBaseline;
            this.hypSys = hypSys;
            this.refs = refs;
            this.metricScoresBaseline = metricScoresBaseline;
            this.metricScoresSys = metricScoresSys;
        }

        public double diff(int iMetric) {
            return this.metricScoresSys[iMetric] - this.metricScoresBaseline[iMetric];
        }
    }
}

