/*
 * Decompiled with CFR 0.152.
 */
package multeval;

import java.util.ArrayList;
import java.util.List;
import multeval.metrics.SuffStats;

public class SuffStatManager {
    private final List<List<List<List<SuffStats<?>>>>> statsBySys;
    private final int numMetrics;
    private final int numOpt;
    private final int numHyp;
    private static final SuffStats<?> DUMMY = null;

    public SuffStatManager(int numMetrics, int numSys, int numOpt, int numHyp) {
        this.numMetrics = numMetrics;
        this.numOpt = numOpt;
        this.numHyp = numHyp;
        this.statsBySys = new ArrayList(numSys);
        for (int iSys = 0; iSys < numSys; ++iSys) {
            this.statsBySys.add(new ArrayList(numOpt));
            List<List<List<SuffStats<?>>>> statsByOpt = this.statsBySys.get(iSys);
            for (int iOpt = 0; iOpt < numOpt; ++iOpt) {
                statsByOpt.add(new ArrayList(numMetrics));
                List<List<SuffStats<?>>> statsByMetric = statsByOpt.get(iOpt);
                for (int iMetric = 0; iMetric < numMetrics; ++iMetric) {
                    statsByMetric.add(new ArrayList(numHyp));
                    List<SuffStats<?>> statsByHyp = statsByMetric.get(iMetric);
                    for (int iHyp = 0; iHyp < numHyp; ++iHyp) {
                        statsByHyp.add(DUMMY);
                    }
                }
            }
        }
    }

    public void saveStats(int iMetric, int iSys, int iOpt, int iHyp, SuffStats<?> stats) {
        List<List<List<SuffStats<?>>>> statsByOpt = this.statsBySys.get(iSys);
        List<List<SuffStats<?>>> statsByMetric = statsByOpt.get(iOpt);
        List<SuffStats<?>> statsByHyp = statsByMetric.get(iMetric);
        statsByHyp.set(iHyp, stats);
    }

    public SuffStats<?> getStats(int iMetric, int iSys, int iOpt, int iHyp) {
        return this.getStats(iMetric, iSys, iOpt).get(iHyp);
    }

    public List<SuffStats<?>> getStats(int iMetric, int iSys, int iOpt) {
        return this.getStats(iSys, iOpt).get(iMetric);
    }

    public List<List<SuffStats<?>>> getStats(int iSys, int iOpt) {
        return this.statsBySys.get(iSys).get(iOpt);
    }

    public List<List<SuffStats<?>>> getStatsAllOptForSys(int iSys) {
        ArrayList resultByMetric = new ArrayList(this.numMetrics);
        List<List<List<SuffStats<?>>>> statsByOpt = this.statsBySys.get(iSys);
        for (int iMetric = 0; iMetric < this.numMetrics; ++iMetric) {
            ArrayList resultByHyp = new ArrayList(this.numHyp * this.numOpt);
            resultByMetric.add(resultByHyp);
            for (int iOpt = 0; iOpt < this.numOpt; ++iOpt) {
                List<List<SuffStats<?>>> statsByMetric = statsByOpt.get(iOpt);
                List<SuffStats<?>> statsByHyp = statsByMetric.get(iMetric);
                resultByHyp.addAll(statsByHyp);
            }
        }
        return resultByMetric;
    }
}

