/*
 * Decompiled with CFR 0.152.
 */
package multeval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultsManager {
    private final List<List<Map<Type, Double>>> resultsBySys;
    private int numMetrics;
    public final String[] metricNames;
    public final String[] sysNames;
    public final int numOptRuns;

    public ResultsManager(String[] metricNames, String[] sysNames, int numOptRuns) {
        this.metricNames = metricNames;
        this.sysNames = sysNames;
        this.numOptRuns = numOptRuns;
        this.numMetrics = metricNames.length;
        int numSys = sysNames.length;
        this.resultsBySys = new ArrayList<List<Map<Type, Double>>>(numSys);
    }

    public void report(int iMetric, int iSys, Type type, double d) {
        while (this.resultsBySys.size() <= iSys) {
            this.resultsBySys.add(new ArrayList(this.numMetrics));
        }
        List<Map<Type, Double>> resultsByMetric = this.resultsBySys.get(iSys);
        while (resultsByMetric.size() <= iMetric) {
            resultsByMetric.add(new HashMap());
        }
        Map<Type, Double> map = resultsByMetric.get(iMetric);
        map.put(type, d);
        System.err.println("RESULT: " + this.sysNames[iSys] + ": " + this.metricNames[iMetric] + ": " + type.name() + ": " + String.format("%.6f", d));
    }

    public Double get(int iMetric, int iSys, Type type) {
        List<Map<Type, Double>> resultsByMetric = this.resultsBySys.get(iSys);
        if (resultsByMetric == null) {
            throw new RuntimeException("No results found for system + " + iSys);
        }
        Map<Type, Double> resultsByType = resultsByMetric.get(iMetric);
        if (resultsByType == null) {
            throw new RuntimeException("No results found for system " + iSys + " for metric " + iMetric);
        }
        Double result = resultsByType.get((Object)type);
        if (result == null) {
            throw new RuntimeException("No results found for system " + iSys + " for metric " + iMetric + " of type " + (Object)((Object)type));
        }
        return result;
    }

    public static enum Type {
        AVG,
        STDDEV,
        MIN,
        MAX,
        RESAMPLED_MEAN_AVG,
        RESAMPLED_STDDEV_AVG,
        RESAMPLED_MIN,
        RESAMPLED_MAX,
        P_VALUE,
        MEDIAN,
        MEDIAN_IDX;

    }
}

