/*
 * Decompiled with CFR 0.152.
 */
package multeval;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.List;
import multeval.metrics.SuffStats;

public class NbestEntry {
    public int sentId;
    public int origRank;
    public String hyp;
    public String feats;
    public float total;
    public double[] metricScores;
    public int[] metricRank;
    public double[] submetricScores;
    public List<SuffStats<?>> metricStats;

    public static NbestEntry parse(String cdecStr, int origRank, int numMetrics) {
        NbestEntry result = new NbestEntry();
        Iterator<String> columns = Splitter.on(" ||| ").split(cdecStr).iterator();
        result.sentId = Integer.parseInt(columns.next());
        result.hyp = columns.next();
        result.feats = columns.next();
        result.total = Float.parseFloat(columns.next());
        result.origRank = origRank;
        result.metricRank = new int[numMetrics];
        return result;
    }

    public String toString(String[] metricNames, String[] submetricNames) {
        StringBuilder rankStr = new StringBuilder("origRank=" + this.origRank);
        for (int iMetric = 0; iMetric < metricNames.length; ++iMetric) {
            rankStr.append(" " + metricNames[iMetric] + "Rank=" + this.metricRank[iMetric]);
        }
        StringBuilder metricString = new StringBuilder();
        if (this.metricScores != null) {
            metricString.append(" |||");
            for (int iMetric = 0; iMetric < metricNames.length; ++iMetric) {
                metricString.append(" " + metricNames[iMetric] + "=" + this.metricScores[iMetric]);
            }
        }
        if (this.submetricScores != null) {
            for (int iSub = 0; iSub < submetricNames.length; ++iSub) {
                metricString.append(" " + submetricNames[iSub] + "=" + this.submetricScores[iSub]);
            }
        }
        return String.format("%d ||| %s ||| %s ||| %f ||| %s", this.sentId, this.hyp, this.feats, Float.valueOf(this.total), rankStr.toString()) + metricString.toString();
    }
}

