/*
 * Decompiled with CFR 0.152.
 */
package multeval;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import jannopts.ConfigurationException;
import jannopts.Configurator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import multeval.Module;
import multeval.MultEvalModule;
import multeval.NbestModule;
import multeval.metrics.BLEU;
import multeval.metrics.Length;
import multeval.metrics.METEOR;
import multeval.metrics.Metric;
import multeval.metrics.TER;

public class MultEval {
    public static Map<String, Metric<?>> KNOWN_METRICS = ImmutableMap.builder().put("bleu", new BLEU()).put("meteor", (BLEU)((Object)new METEOR())).put("ter", (BLEU)((Object)new TER())).put("length", (BLEU)((Object)new Length())).build();
    private static final ImmutableMap<String, Module> MODULES = new ImmutableMap.Builder<String, MultEvalModule>().put("eval", new MultEvalModule()).put("nbest", (MultEvalModule)((Object)new NbestModule())).build();

    static List<Metric<?>> loadMetrics(String[] metricNames, Configurator opts) throws ConfigurationException {
        ArrayList metrics = new ArrayList();
        for (String metricName : metricNames) {
            System.err.println("Loading metric: " + metricName);
            Metric<?> metric = KNOWN_METRICS.get(metricName.toLowerCase());
            if (metric == null) {
                throw new RuntimeException("Unknown metric: " + metricName + "; Known metrics are: " + KNOWN_METRICS.keySet());
            }
            opts.activateDynamicOptions(metric.getClass());
            metrics.add(metric);
        }
        for (Metric metric : metrics) {
            metric.configure(opts);
        }
        return metrics;
    }

    static int initThreads(List<Metric<?>> metrics, int threads) {
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        System.err.println("Using " + threads + " threads");
        return threads;
    }

    private static String loadVersion() throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream("constants");
        props.load(in);
        in.close();
        String version = props.getProperty("version");
        return version;
    }

    public static void main(String[] args) throws ConfigurationException, IOException, InterruptedException {
        String version = MultEval.loadVersion();
        System.err.println(String.format("MultEval V%s\n", version) + "By Jonathan Clark\n" + "Using Libraries: METEOR (Michael Denkowski) and TER (Matthew Snover)\n");
        if (args.length == 0 || !((ImmutableCollection)((Object)MODULES.keySet())).contains(args[0])) {
            System.err.println("Usage: program <module_name> <module_options>");
            System.err.println("Available modules: " + ((ImmutableCollection)((Object)MODULES.keySet())).toString());
            System.exit(1);
        } else {
            String moduleName = args[0];
            Module module = MODULES.get(moduleName);
            Configurator opts = new Configurator().withModuleOptions(moduleName, module.getClass());
            for (Class<?> c : module.getDynamicConfigurables()) {
                opts.allowDynamicOptions(c);
            }
            try {
                opts.readFrom(args);
                opts.configure(module);
            }
            catch (ConfigurationException e) {
                opts.printUsageTo(System.err);
                System.err.println("ERROR: " + e.getMessage() + "\n");
                System.exit(1);
            }
            module.run(opts);
        }
    }
}

