/*
 * Decompiled with CFR 0.152.
 */
package multeval;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import multeval.util.StringUtils;

public class HypothesisManager {
    private List<List<String>> allRefs = new ArrayList<List<String>>();
    private List<List<List<String>>> allHyps = new ArrayList<List<List<String>>>();
    private int numHyps = -1;
    private int numRefs = -1;
    private int numOptRuns = -1;
    private int numSystems = -1;

    public int getNumHyps() {
        return this.numHyps;
    }

    public int getNumOptRuns() {
        return this.numOptRuns;
    }

    public int getNumRefs() {
        return this.numRefs;
    }

    public void loadData(String[] hypFilesBaseline, String[][] hypFilesBySys, String[] refFiles) throws IOException {
        this.numSystems = hypFilesBySys.length + 1;
        this.allHyps.clear();
        this.loadHyps(hypFilesBaseline, "baseline");
        for (int iSys = 0; iSys < hypFilesBySys.length; ++iSys) {
            this.loadHyps(hypFilesBySys[iSys], "" + (iSys + 1));
        }
        this.numRefs = refFiles.length;
        this.allRefs = HypothesisManager.loadRefs(refFiles, this.numHyps);
    }

    public static List<List<String>> loadRefs(String[] refFiles, int numHypsHint) throws IOException {
        ArrayList<List<String>> allRefs = new ArrayList<List<String>>();
        int numRefs = refFiles.length;
        while (allRefs.size() <= numHypsHint) {
            allRefs.add(new ArrayList(numRefs));
        }
        for (String refFile : refFiles) {
            List<String> oneRefPerHyp = HypothesisManager.loadSentences(refFile, "non-laced references");
            if (numHypsHint != oneRefPerHyp.size()) {
                throw new RuntimeException("Non-parallel inputs detected. Expected " + numHypsHint + " references, but got " + oneRefPerHyp.size());
            }
            for (int iHyp = 0; iHyp < oneRefPerHyp.size(); ++iHyp) {
                String ref = oneRefPerHyp.get(iHyp);
                ((List)allRefs.get(iHyp)).add(ref);
            }
        }
        return allRefs;
    }

    private void loadHyps(String[] hypFiles, String sys) throws IOException {
        if (this.numOptRuns == -1) {
            this.numOptRuns = hypFiles.length;
        } else if (this.numOptRuns != hypFiles.length) {
            throw new RuntimeException("Non-parallel number of optimization runs. Expected " + this.numOptRuns + " but got " + hypFiles.length);
        }
        ArrayList<List<String>> sysHypsForAllOptRuns = new ArrayList<List<String>>();
        this.allHyps.add(sysHypsForAllOptRuns);
        for (int iOpt = 0; iOpt < this.numOptRuns; ++iOpt) {
            List<String> hypsForOptRun = HypothesisManager.loadSentences(hypFiles[iOpt], "Hypotheses for system " + sys + " opt run " + (iOpt + 1));
            sysHypsForAllOptRuns.add(hypsForOptRun);
            if (this.numHyps == -1) {
                this.numHyps = hypsForOptRun.size();
                continue;
            }
            if (this.numHyps == hypsForOptRun.size()) continue;
            throw new RuntimeException("Non-parallel inputs detected. Expected " + this.numHyps + " hypotheses, but got " + hypsForOptRun.size());
        }
    }

    public static List<String> loadSentences(String hypFile, String forWhat) throws IOException {
        File file = new File(hypFile);
        System.err.println("Reading " + forWhat + " file " + file.getAbsolutePath());
        List<String> sentences = Files.readLines(file, Charsets.UTF_8);
        for (int i = 0; i < sentences.size(); ++i) {
            String sent = sentences.get(i);
            sent = StringUtils.normalizeWhitespace(sent);
            sentences.set(i, sent);
        }
        return sentences;
    }

    public int getNumSystems() {
        return this.numSystems;
    }

    public List<String> getHypotheses(int iSys, int iOpt) {
        return this.allHyps.get(iSys).get(iOpt);
    }

    public String getHypothesis(int iSys, int iOpt, int iHyp) {
        return this.getHypotheses(iSys, iOpt).get(iHyp);
    }

    public List<String> getReferences(int iHyp) {
        return this.allRefs.get(iHyp);
    }

    public List<List<String>> getAllReferences() {
        return this.allRefs;
    }
}

