/*
 * Decompiled with CFR 0.152.
 */
package jbleu.util;

import java.util.List;
import jbleu.util.HashUtil;

public class Ngram {
    private List<String> toks;
    private int hash = 0;

    public Ngram(List<String> toks) {
        this.toks = toks;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (String tok : this.toks) {
                this.hash ^= HashUtil.smear(tok.hashCode());
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ngram) {
            Ngram other = (Ngram)obj;
            return ((Object)this.toks).equals(other.toks);
        }
        throw new RuntimeException("Comparing n-gram to non-n-gram");
    }

    public String toString() {
        return this.toks.toString();
    }
}

